# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.db.models import TextField, ForeignKey, IntegerField, CharField, SmallIntegerField
from django.db.models import BooleanField, DateTimeField, URLField, OneToOneField

from wiki.models.item import Item
from api.models import Tag

class Collect(models.Model):
    class Meta:
        verbose_name = u'聚合'
        db_table = 'wiki_collect'

    name = CharField(u'聚合名称', max_length=48)
    description = TextField(u'简介')
    is_online = BooleanField(u'是否上线', default=True)
    create_time = DateTimeField(u'创建时间', auto_now_add=True)


class CollectItem(models.Model):
    class Meta:
        verbose_name = '聚合项目'
        db_table = 'wiki_collectitem'

    collect = ForeignKey(Collect, related_name='items')
    item = ForeignKey(Item)
    rank = IntegerField(u'排序')
    is_online = BooleanField(u'是否上线', default=True)


class TopItem(models.Model):
    class Meta:
        verbose_name = '聚合置顶标题'
        db_table = 'polymer_toptitle'

    title = CharField('置顶标题1', max_length=32)
    url = URLField('标题1的url', max_length=256)
    ordering = SmallIntegerField('置顶位置')
    polymer_id = IntegerField('polymerID')

    @classmethod
    def get_top_topic(cls, polymer_id=None):
        if not polymer_id:
            return []
        all_top = TopItem.objects.filter(polymer_id=polymer_id)
        list_all = []
        if len(all_top) == 0:
            return []
        else:
            for item in all_top:
                if item.title:
                    list_all.append({
                        'url': item.url,
                        'content': item.title
                    })

        return list_all


class CollectTag(models.Model):
    class Meta:
        verbose_name = u'项目聚合百科关联标签'
        db_table = 'wiki_collect_tag'

    collect = ForeignKey(Collect, verbose_name=u'项目聚合百科', related_name='tags')
    tag = ForeignKey(Tag, verbose_name=u'标签')