# !/usr/bin/env python
# encoding=utf-8
import os
import uuid
import time
import logging
from celery.signals import worker_process_init
from gm_logging.py_logging import AppHandler


@worker_process_init.connect
def init_task_service_worker(**kwargs):
    """
    ONLY call this function in worker!
    因为 gm-logging 初始化后不能 fork 否则会导致写入 kafka 的 BUG，因此将初始化过程放在这里。
    """
    from rpc.app import initialize_gm_logging
    initialize_gm_logging()

    print(
        'init_task_service_worker: worker process initialized, pid={}, ppid={}, kwargs={}'.format(
            os.getpid(),
            os.getppid(),
            repr(kwargs),
        )
    )
