# coding:utf-8
from django.core.management.base import BaseCommand

from agile.models.tag import TagAttrRelation
from utils.execel import ExcelReader


class Command(BaseCommand):
    """
    标签属性 关联 python manage.py attr_tag_related_map
    """
    def handle(self, *args, **options):
        print('START')
        # 增加新映射关系
        related_objects = []
        excel = ExcelReader('/tmp/标签导入模板.xlsx')
        for row in range(excel.row_number):
            data = excel.read_row(row)
            if len(data) < 2:
                continue
            parent_id = data[0]
            child_id = data[1]
            related_objects.append(TagAttrRelation(parent_id=parent_id, child_id=child_id))

        TagAttrRelation.objects.bulk_create(related_objects)
        print("Done")
