# coding:utf-8

from django.core.management.base import BaseCommand
from utils.execel import ExcelWriter

from gm_types.gaia import TAG_TYPE_ATTR, TAG_V3_TYPE
from agile.models.tag import (
    TagV3,
    AttrTag,
    TagV3MapAttrTag,
    TagMapOldTag,
    TagAttrRelation,
)
from api.models import Tag


class TagService(object):

    ####### 老标签与属性标签关联  #########

    @staticmethod
    def list_names(attr_ids, _type):

        return ", ".join(
            list(
                AttrTag.objects.filter(id__in=attr_ids, aggregate_type=_type).values_list("name", flat=True)
            )
        )

    @classmethod
    def get_names_by_attr_type(cls, obj, attr_type):
        """根据属性标签获取对应类型的属性名称列表。"""

        attr_ids = cls.list_tag_attr_ids(obj)
        return cls.list_names(attr_ids, attr_type)

    @staticmethod
    def list_tag_attr_ids(obj):
        return list(TagV3MapAttrTag.objects.filter(tag_id=obj.id).values_list('tag_attr_id', flat=True))

    @classmethod
    def related_old_tags(cls, obj):  # 关联老标签
        old_tag_ids = TagMapOldTag.objects.filter(tag_id=obj.id).values_list('old_tag_id', flat=True)
        return ", ".join(list(Tag.objects.filter(pk__in=old_tag_ids).values_list('name', flat=True)))

    ####### 属性标签关联  #########

    @staticmethod
    def list_child_ids(obj):
        return list(TagAttrRelation.objects.filter(parent_id=obj.id).values_list('child_id', flat=True))

    @classmethod
    def list_type_children_names_by_parent(cls, obj, _type):
        attr_ids = cls.list_child_ids(obj)
        return cls.list_names(attr_ids, _type)

    ### 新标签

    @classmethod
    def xx_to_brand(cls, obj):
        """品牌"""
        tag_ids = list(TagV3MapAttrTag.objects.filter(tag_attr_id=obj.id).values_list('tag_id', flat=True))
        return ", ".join(
            list(
                TagV3.objects.filter(id__in=tag_ids, tag_type=TAG_V3_TYPE.BRAND).values_list("name", flat=True)
            )
        )


class Command(BaseCommand):

    def handle(self, *args, **options):

        excel = ExcelWriter("./tag_3.xlsx")

        excel.create_sheet(u"项目")
        excel.write_header([
            u"项目标签",
            u"一级部位", u"二级部位", u"一级药品仪器耗材", u"二级药品仪器耗材",
            u"二级诉求", u"一级诉求", u"二级方式", u"一级方式",
            u"老标签"
        ])
        write_rows = []
        for tag in TagV3.objects.filter(tag_type=TAG_V3_TYPE.NORMAL, is_online=True):
            a = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.FIRST_POSITION)  # 一级部位
            b = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.POSITION)  # 二级部位
            c = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.MODE)  # 一级药品仪器耗材
            d = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.BRAND)  # 二级药品仪器耗材
            e = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.SECOND_APPEAL)  # 二级诉求
            f = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.FIRST_APPEAL)  # 一级诉求
            g = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.MODE)  # 二级方式
            h = TagService.get_names_by_attr_type(tag, TAG_TYPE_ATTR.MACROSCOPIC_MODE)  # 一级方式
            i = TagService.related_old_tags(tag)  # 老标签

            write_rows.append([tag.name, a, b, c, d, e, f, g, h, i])
        excel.write_rows(2, write_rows)
        excel.save()

        excel.create_sheet(u"一级诉求")
        excel.write_header([
            u"一级诉求", u"二级诉求"
        ])
        write_rows = []
        for attr in AttrTag.objects.filter(aggregate_type=TAG_TYPE_ATTR.FIRST_APPEAL):  # 一级诉求
            # SECOND_APPEAL 二级诉求
            names = TagService.list_type_children_names_by_parent(attr, TAG_TYPE_ATTR.SECOND_APPEAL)
            write_rows.append([attr.name, names])
        excel.write_rows(2, write_rows)
        excel.save()

        excel.create_sheet(u"一级部位")
        excel.write_header([
            u"一级部位", u"二级部位"
        ])
        write_rows = []
        for attr in AttrTag.objects.filter(aggregate_type=TAG_TYPE_ATTR.FIRST_POSITION):  # 一级部位
            # POSITION 二级部位
            names = TagService.list_type_children_names_by_parent(attr, TAG_TYPE_ATTR.POSITION)
            write_rows.append([attr.name, names])
        excel.write_rows(2, write_rows)
        excel.save()

        excel.create_sheet(u"一级方式")
        excel.write_header([
            u"一级方式", u"1级药品仪器耗材"
        ])
        write_rows = []
        for attr in AttrTag.objects.filter(aggregate_type=TAG_TYPE_ATTR.MACROSCOPIC_MODE):  # 一级方式
            # FIRST_BRAND 1级药品仪器耗材
            names = TagService.list_type_children_names_by_parent(attr, TAG_TYPE_ATTR.MODE)
            write_rows.append([attr.name, names])
        excel.write_rows(2, write_rows)
        excel.save()

        excel.create_sheet(u"1级药品仪器耗材")
        excel.write_header([
            u"1级药品仪器耗材", u"2级药品仪器耗材"
        ])
        write_rows = []
        for attr in AttrTag.objects.filter(aggregate_type=TAG_TYPE_ATTR.MODE):  # 1级药品仪器耗材
            # BRAND 2级药品仪器耗材
            names = TagService.list_type_children_names_by_parent(attr, TAG_TYPE_ATTR.BRAND)
            write_rows.append([attr.name, names])
        excel.write_rows(2, write_rows)
        excel.save()

        excel.create_sheet(u"2级药品仪器耗材")
        excel.write_header([
            u"2级药品仪器耗材", u"品牌"
        ])
        write_rows = []
        for attr in AttrTag.objects.filter(aggregate_type=TAG_TYPE_ATTR.BRAND):  # 2级药品仪器耗材
            # TAG_V3_TYPE.BRAND 品牌标签
            names = TagService.xx_to_brand(attr)
            write_rows.append([attr.name, names])
        excel.write_rows(2, write_rows)
        excel.save()

        print('DONE')
