# coding:utf-8
from django.core.management.base import BaseCommand
from utils.execel import ExcelReader
from agile.models.tag import TagMapOldTag


class Command(BaseCommand):
    """
    下线 表api_tag_map_oldtag 中所有的映射关系
    """

    def handle(self, *args, **options):
        print('START')
        # 下线之前的映射关系
        TagMapOldTag.objects.all().update(is_online=False)

        # 增加新映射关系
        excel = ExcelReader('/tmp/录入标签关系.xlsx')
        tag_map_list = []

        for row in range(excel.row_number):
            data = excel.read_row(row)

            if len(data) < 4:
                continue

            tag_id = str( data[1])
            old_tag_id = str(data[3])
            if not (tag_id.isdigit() and old_tag_id.isdigit()):
                continue

            tag_map_list.append(TagMapOldTag(
                tag_id=tag_id,
                old_tag_id=old_tag_id,
            ))

        i = 0
        deal_count = 100
        while i < len(tag_map_list):
            TagMapOldTag.objects.bulk_create(tag_map_list[i: i + deal_count])
            i += deal_count

        print('DONE')
