#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django.core.management import BaseCommand
from gm_types.gaia import TAG_TYPE_ATTR

from agile.models import TagV3, AttrTag

_types = [
    TAG_TYPE_ATTR.FIRST_APPEAL, TAG_TYPE_ATTR.SECOND_APPEAL,
    TAG_TYPE_ATTR.MACROSCOPIC_MODE, TAG_TYPE_ATTR.MODE,
    TAG_TYPE_ATTR.FIRST_POSITION, TAG_TYPE_ATTR.POSITION,

]


class Command(BaseCommand):
    """
    python manage.py tag3_online
    """

    def handle(self, *args, **options):
        TagV3.objects.all().update(is_display=True, is_online=True)
        AttrTag.objects.filter(aggregate_type__in=_types).update(is_online=True)

        print('Done')
