# coding:utf-8
from datetime import datetime
from django.core.management.base import BaseCommand

from agile.models.tag import TagV3


class Command(BaseCommand):
    """ 处理重复标签 """
    def handle(self, *args, **options):
        sql_str = 'select id, name, tag_type, count(name) as cnt from api_tag_3_0 group by name having cnt > 1'
        tags = TagV3.objects.raw(sql_str)
        for tag in tags:
            TagV3.objects.filter(id=tag.id).update(name=tag.name+'1')

