# -*- coding: utf-8 -*-


from django.core.management import BaseCommand

from lasker.models import AwardResult

import datetime


class Command(BaseCommand):
    """ Import famous doctor award list from txt to database """

    def handle(self, *args, **options):
        print("Start Insert AwardResult Data!")
        with open("2019_famous_doctor_list.txt") as of:
            update_or_create_count = 0
            for line in of.readlines():
                line_details = line.split()
                AwardResult.objects.update_or_create(
                    laureate_id=line_details[1].decode('utf-8'),
                    defaults={
                        'laureate_name': line_details[0].decode('utf-8'),
                        'laureate_type': int(line_details[5]),
                        'award_name': line_details[2].decode('utf-8'),
                        'is_deleted': False,
                        'online_time': datetime.datetime.strptime(line_details[3], "%Y-%m-%d"),
                        'offline_time': datetime.datetime.strptime(line_details[4], "%Y-%m-%d"),
                        'is_special_skin': int(line_details[6])
                    }
                )
                update_or_create_count += 1
                print("AwardResult Success Insert One Column Data！Index %d" % update_or_create_count)
        print("Success!!!, Total %d Column" % update_or_create_count)

