# coding: utf-8

# 2020 名医大赏 美购增加标签

from django.core.management import BaseCommand

from api.models import Service, ServiceTag, Tag
from gm_types.gaia import TAG_TYPE


tag2service_ids = {
    u'2019-年度优秀私密整形医生': ['5758093', '5758746', '5758756'],
    u'2019-年度优秀眼部整形医生': ['5809063', '5809276', '5767521'],
    u'2019-年度优秀鼻部整形医生': ['5840468', '5840491', '5864089'],
    u'2019-年度优秀脂肪管理医生': ['5823634', '5299163', '5456115'],
    u'2019-年度优秀颌面整形机构': ['5815356', '5834997', '5858006'],
    u'2019-年度优秀鼻部整形机构': ['5803913', '5860750', '5860771'],
    u'2019-年度优秀口碑整形机构': ['5240975', '5832387', '5191770'],
    u'2019-年度口碑整形机构': ['5746636', '5746188', '5774732'],
    u'2019-年度实力整形机构': ['5822144', '5752820', '5750162'],
    u'2019-年度优秀颌面整形医生': ['5798876', '5798887', '5798886'],
    u'2019-年度优秀胸部整形机构': ['5773563', '5836484', '5851722'],
    u'2019-年度优秀私密整形机构': ['5801676', '5801679', '5801677'],
    u'2019-年度人气整形机构': ['5788111', '5788109', '5850825'],
    u'2019-年度优秀眼部整形机构': ['5756487', '5798748', '5756488']
}


class Command(BaseCommand):

    def handle(self, *args, **options):
        for tag_name, service_ids in tag2service_ids.items():
            tag = Tag.objects.filter(name=tag_name).first()
            if not tag:
                tag = Tag()
                tag.name = tag_name
                tag.tag_type = TAG_TYPE.YUNYING
                tag.is_online = 1
                tag.banner_url = ""
                tag.ordering = 100
            tag.is_online = 1
            tag.save()

            exec_info = list()
            for service_id in service_ids:
                service_id = int(service_id)
                if Service.objects.filter(id=service_id).first():
                    ServiceTag.objects.update_or_create(service_id=service_id, tag_id=tag.id)
                    exec_info.append(str(service_id))
                if exec_info:
                    print("成功导入 %s 相关的美购ids %s" % (tag_name, ",".join(exec_info)))
        print("SUCCESS")
