# coding: utf-8


from django.core.management import BaseCommand

from api.models.wordrel import WordGroup, RecommendWords


need_split_words = """瘦脸针	瘦脸,瘦大腿,瘦小腿,光纤溶脂瘦脸,激光溶脂瘦脸,吸脂瘦脸,瘦腿针
双眼皮	双眼皮,开眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
热玛吉	紧致提升,上眼睑提升,颈部提升,热拉提,超声刀,射频提升,面部线雕,切眉,胶原蛋白祛颈纹
光子嫩肤	祛斑,祛痘印,祛痘坑,美白,彩光嫩肤,激光祛斑,激光美肤,白瓷娃娃,黑脸娃娃,皮秒
脱毛	脱毛,脱手脚毛,脱腋毛,脱全身毛发,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛
水光针	补水,祛眼纹,美白,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入
美白针	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑,彩光嫩肤,黑脸娃娃,白瓷娃娃
鼻综合	隆鼻,缩鼻翼,鼻尖延长,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
玻尿酸	填充苹果肌,丰太阳穴,垫下巴,隆鼻,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸隆鼻
吸脂	瘦大腿,瘦小腿,瘦手臂,瘦脸,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦脸,瘦腿针,瘦脸针
果酸焕肤	祛痘,果酸焕肤,点阵激光,微针美塑,红蓝光祛痘,无针水光,菲洛嘉
瘦腿针	瘦腿,瘦大腿,瘦小腿,瘦脸,吸脂瘦大腿,吸脂瘦小腿,瘦肩针,瘦脸针
下颌角	面部轮廓,缩下颌角,垫下巴,丰太阳穴,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴,自体脂肪丰面颊
线雕	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,热玛吉,切眉
植发	植发,生眉毛,生发际线,种植发际线,植眉,植鬓角,半永久纹眉
小气泡	祛黑头,补水,祛痘,控油,水氧活肤,无针水光,玻尿酸导入,果酸焕肤
隆胸	隆胸,胸部护理,乳晕美化,胸部提升,假体隆胸,自体脂肪隆胸,综合隆胸
皮秒	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃
面部吸脂	瘦脸,光纤溶脂瘦脸,黄金微雕,射频溶脂,瘦脸针,激光溶脂瘦脸
瘦肩针	瘦肩,瘦脸,瘦腿,瘦大腿,瘦小腿,瘦腿针,瘦脸针,吸脂瘦大腿
微针	祛痘,果酸焕肤,点阵激光,微针美塑,红蓝光祛痘,无针水光,菲洛嘉
祛斑	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
点阵激光	祛痘坑,祛痘印,美白, 黄金微针,微针祛痘,红蓝光祛痘,光子嫩肤,皮秒
热拉提	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,超声刀,射频紧肤,面部线雕,黄金微针
眼综合	双眼皮,开眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
超声刀	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,热拉提,射频紧肤,面部线雕,黄金微针
超皮秒	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃
菲洛嘉	补水,美白,祛痘,水光针,无针水光,婴儿针,微针水光,水氧活肤,玻尿酸精华导入
隆鼻	隆鼻,缩鼻翼,鼻尖延长,鼻综合,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
颧骨内推	面部轮廓,颧骨内推,垫下巴,瘦脸,颧骨降低,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴
祛痘	祛痘,祛痘坑,祛痘印, 点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
鼻基底	垫鼻基底,隆鼻,缩鼻翼,鼻尖延长,玻尿酸垫鼻基底,假体垫鼻基底,自体脂肪垫鼻基底,膨体隆鼻,鼻综合
牙齿矫正	牙齿矫正,牙齿护理,牙齿清洁,隐形矫正,金属托槽矫正,牙齿半隐形矫正,超声波洗牙,冷光美白,根管治疗
自体脂肪隆胸	隆胸,乳晕美化,假体隆胸,综合隆胸,乳房提升
手术缩鼻翼	缩鼻翼,隆鼻,缩鼻头,埋线缩鼻翼,手术缩鼻翼,耳软骨垫鼻头,鼻小柱延长,鼻中隔延长,鼻综合
自体脂肪填充面部	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
黄金微针	祛痘,祛痘坑,祛痘印,伊肤泉微针, 点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
洗牙	牙齿矫正,牙齿护理,牙齿清洁,超声波洁牙,喷砂洗牙,皓齿美白,冷光美白,根管治疗
溶脂针	瘦脸,光纤溶脂瘦脸,黄金微雕,射频溶脂,瘦脸针,激光溶脂瘦脸
皮秒激光	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
埋线双眼皮	双眼皮,开眼角,眼综合,定点双眼皮,切开双眼皮,双眼皮修复
假体隆胸	隆胸,胸部护理,乳晕美化,胸部提升,自体脂肪隆胸,硅胶隆胸,综合隆胸
缩鼻翼	缩鼻翼,隆鼻,缩鼻头,埋线缩鼻翼,手术缩鼻翼,耳软骨垫鼻头,鼻小柱延长,鼻中隔延长,鼻综合
菲洛嘉水光针	补水,美白,祛痘,水光针,无针水光,婴儿针,微针水光,水氧活肤,玻尿酸精华导入
下巴	垫下巴,祛双下巴,瘦脸,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴
人中缩短	人中缩短,人中延长,M唇,玻尿酸丰唇,嘴角上扬,厚唇改薄,微笑唇
抽脂	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦脸
美白	美白,祛斑,祛痘印,祛痘坑,牙齿美白,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,冷光美白,皓齿美白
保妥适	瘦脸,瘦腿,瘦肩,祛静态纹,瘦脸针,瘦腿针,瘦肩针
除皱	祛抬头纹,祛面部细纹,祛眼纹,祛眉间纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹
嗨体	祛颈纹,肉毒素祛颈纹,埋线祛颈纹,玻尿酸祛颈纹,自体脂肪祛颈纹
法令纹	祛法令纹,玻尿酸祛法令纹,自体脂肪祛法令纹,假体祛法令纹,肉毒素祛法令纹
脂肪填充	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
眼袋	祛眼袋,填充泪沟,祛黑眼圈,祛眼纹,外切去眼袋,内切祛眼袋,眶隔脂肪释放,玻尿酸填充泪沟,激光祛黑眼圈
瘦脸	瘦脸,瘦下颌缘,光纤溶脂瘦脸,黄金微雕,射频溶脂,瘦脸针,激光溶脂瘦脸,吸脂瘦脸
头发	植发,生眉毛,生发际线,种植发际线,植眉,植鬓角,半永久纹眉
泪沟	填充泪沟,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈,玻尿酸填充卧蚕
点痣	祛痣,祛疤,美白,激光点痣,切痣,点阵激光,蜂巢皮秒,超皮秒
黄金微雕	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,光纤溶脂,射频溶脂,吸脂瘦全身,水动力吸脂
肋骨鼻	隆鼻,缩鼻翼,鼻尖延长,鼻综合,硅胶隆鼻,假体隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
黑眼圈	祛眼袋,填充泪沟,祛黑眼圈,祛眼纹,激光祛黑眼圈,白瓷娃娃,皮秒,玻尿酸祛黑眼圈,内切祛眼袋
祛疤	祛疤,祛痣,注射祛疤,点阵激光,复合彩光,蜂巢皮秒,超皮秒,像素激光
热玛吉五代	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕
瘦腿	瘦腿,瘦大腿,瘦小腿,瘦腿针,吸脂瘦腿,水动力吸脂,黄金微雕,冷冻溶脂瘦腿
纹眉	生眉毛,上眼睑提升,眼角提升,祛眉间纹,半永久纹眉,植眉,玻尿酸祛眉间纹,切眉,洗眉
开眼角	开眼角,开内眼角,开外眼角,定点双眼皮,埋线双眼皮,切开双眼皮,眼综合
拉皮	紧致提升,上眼睑提升,颈部提升,小切口提升,热玛吉,射频提升,超声刀,射频紧肤,面部线雕,黄金微针
祛眼袋	祛眼袋,填充泪沟,祛黑眼圈,祛眼纹,外切去眼袋,内切祛眼袋,眶隔脂肪释放,玻尿酸填充泪沟,激光祛黑眼圈
眼睑下至	下眼睑下至,开内眼角,开外眼角,切开双眼皮,埋线双眼皮,上眼睑提肌
鼻子	隆鼻,缩鼻翼,鼻尖延长,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
艾莉薇	隆鼻,缩鼻翼,鼻尖延长,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头
M22	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,黑脸娃娃,白瓷娃娃
牙齿美白	牙齿矫正,牙齿美白,牙齿清洁,冷光美白,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙
种植发际线	生发际线,植发,生眉毛,种植发际线,植眉,植鬓角,半永久纹眉,洗眉
激光祛斑	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
颧骨	面部轮廓,颧骨内推,垫下巴,瘦脸,颧骨降低,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴
玻尿酸注射	填充苹果肌,丰太阳穴,垫下巴,隆鼻,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸隆鼻
点阵	祛痘坑,祛痘印,祛痘, 黄金微针,微针祛痘,红蓝光祛痘,光子嫩肤,皮秒
韩式半永久纹眉	生眉毛,祛眉间纹,上眼睑提升,半永久纹眉,植眉,玻尿酸祛眉间纹,切眉,洗眉
白瓷娃娃	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,黑脸娃娃,光子嫩肤
丰胸（隆胸）	隆胸,乳晕美化,胸部提升,假体隆胸,硅胶隆胸,自体脂肪隆胸,复合隆胸,乳房提升
腰腹吸脂	瘦腰腹,光纤溶脂,黄金微雕,射频溶脂,水动力吸脂
伊肤泉微针	祛痘,祛痘印,祛痘,伊肤泉微针, 点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
祛痘印	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
切开双眼皮	双眼皮,开眼角,眼综合,定点双眼皮,埋线双眼皮,上眼睑提肌,双眼皮修复
祛痣	祛痣,美白,祛痘印,激光点痣,切痣,点阵激光,蜂巢皮秒,超皮秒,光子嫩肤
丰唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇
超声提升	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,射频紧肤,面部线雕,黄金微针, 小切口提升
M唇成形术	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,玻尿酸丰唇珠,唇 ,微笑唇,厚唇改薄,漂唇,嘟嘟唇
去眼袋	祛眼袋,祛黑眼圈,填充泪沟,祛眼纹,外切去眼袋,内切祛眼袋,眶隔脂肪释放,玻尿酸填充泪沟,激光祛黑眼圈
除皱针注射	祛抬头纹,祛面部细纹,祛眼纹,祛眉间纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹
胶原蛋白填充泪沟	填充泪沟,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈,玻尿酸填充卧蚕
激光脱毛	脱毛,脱手脚毛,脱腋毛,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛
自体脂肪填充	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
厚唇改薄	丰唇,嘴角上扬,薄唇,厚唇改薄,m唇,漂唇,微笑唇,嘟嘟唇
溶脂	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,溶脂针,光纤溶脂,射频溶脂,吸脂瘦全身,水动力吸脂
伊婉V	填充苹果肌,丰太阳穴,垫下巴,隆鼻,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸隆鼻
果酸	祛痘,祛痘印,祛痘,伊肤泉微针, 点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
收缩毛孔	缩毛孔,祛痘印,祛斑,黑脸娃娃,微针,点阵激光,光子嫩肤,蜂巢皮秒,超皮秒
光纤溶脂	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,激光溶脂,射频溶脂,吸脂瘦全身,水动力吸脂
嗨体去颈纹	祛颈纹,肉毒素祛颈纹,埋线祛颈纹,玻尿酸祛颈纹,自体脂肪祛颈纹
伊婉v	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,玻尿酸隆鼻,自体脂肪丰苹果肌,自体脂肪丰太阳穴,自体脂肪填充泪沟
爱芙莱	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,玻尿酸隆鼻,自体脂肪丰苹果肌,自体脂肪丰太阳穴,自体脂肪填充泪沟
自体脂肪全脸填充	填充苹果肌,填充泪沟,丰太阳穴,丰额头,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
面部填充	填充苹果肌,丰太阳穴,垫下巴,隆鼻,玻尿酸垫下巴,玻尿酸填充苹果肌,自体脂肪丰太阳穴,自体脂肪填充泪沟
吸脂瘦大腿	瘦腿,瘦大腿,瘦小腿,瘦腿针,激光溶脂瘦腿,光纤溶脂瘦腿,黄金微雕,冷冻溶脂瘦腿
射频	紧致提升,上眼睑提升,颈部提升,瘦全身,瘦大腿,瘦小腿,热拉提,超声刀,面部线雕,激光溶脂,吸脂瘦全身
鼻头	隆鼻,缩鼻头,缩鼻翼,耳软骨垫鼻头,手术延长鼻小柱,鼻中隔软骨垫鼻头,肉毒素缩鼻头
假体下巴	垫下巴,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴
玻尿酸隆鼻	隆鼻,缩鼻头,缩鼻翼,鼻综合,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
水光	补水,祛眼纹,美白,水光针,无针水光,婴儿针,微针水光,水氧活肤,玻尿酸精华导入
下颌缘提升	紧致提升,上眼睑提升,颈部提升,颈部提升,上眼睑提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕,热玛吉,肉毒素瘦下颌缘
冷光美白	牙齿矫正,牙齿美白,牙齿清洁,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙
埋线提升	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,热玛吉
祛黑头	祛黑头,补水,祛痘,小气泡,水氧活肤,无针水光,玻尿酸导入,果酸焕肤,光子嫩肤,红蓝光祛痘
伊婉C	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹
玻尿酸丰下巴	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹
黑脸娃娃	祛斑,祛痘印,祛痘坑,美白,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,光子嫩肤,黄金微针,红蓝光祛痘
除皱针	祛抬头纹,祛面部细纹,祛眼纹,祛眉间纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹
胶原蛋白	祛黑眼圈,祛颈纹,填充泪沟,激光祛黑眼圈,白瓷娃娃,皮秒,玻尿酸祛黑眼圈,玻尿酸填充泪沟,玻尿酸祛颈纹
玻尿酸丰唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
耳软骨隆鼻	隆鼻,缩鼻翼,鼻尖延长,鼻综合,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
私密整形	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
吸脂瘦脸	瘦脸,瘦下颌缘,光纤溶脂瘦脸,黄金微雕,瘦脸针,吸脂瘦全身,吸脂瘦大腿,吸脂瘦腰腹
蜂巢皮秒	美白,祛斑,祛痘印,祛痘坑,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光
眉毛	生眉毛,祛眉间纹,上眼睑提升,植发,半永久纹眉,植眉,玻尿酸祛眉间纹,切眉,洗眉,植发,种植发际线
发际线	生发际线,植发,生眉毛,种植发际线,植眉,植鬓角,半永久纹眉,洗眉
痘坑	祛痘,祛痘坑,祛痘印,伊肤泉微针, 点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
丰胸	隆胸,乳晕美化,胸部提升,假体隆胸,硅胶隆胸,自体脂肪隆胸,复合隆胸,乳房提升
定点双眼皮	双眼皮,开眼角,开内眼角,开外眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
酒窝	酒窝,酒窝成形,m唇,微笑唇,嘟嘟唇,漂唇
提眉	上眼睑提升,双眼皮,切眉,上眼睑提肌,切开双眼皮,眼综合,面部线雕,热玛吉
去黑头	祛痘,祛痘坑,祛痘印, 小气泡,点阵激光,黄金微针,  果酸焕肤, 光子嫩肤,红蓝光祛痘
微针祛痘坑	祛痘印,祛痘坑,点阵激光,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,光子嫩肤,黄金微针,红蓝光祛痘
自体脂肪丰太阳穴	面部轮廓,丰太阳穴,丰额头,玻尿酸填充面部,玻尿酸隆鼻,自体脂肪丰苹果肌,自体脂肪丰太阳穴,自体脂肪填充泪沟
深蓝射频	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,超声刀,热拉提,面部线雕,黄金微针
眶隔脂肪释放	祛眼袋,祛黑眼圈,填充泪沟,祛眼纹,外切去眼袋,内切祛眼袋,玻尿酸填充泪沟,激光祛黑眼圈
溶脂针瘦脸	瘦脸,光纤溶脂瘦脸,黄金微雕瘦脸,射频溶脂瘦脸,瘦脸针,激光溶脂瘦脸,溶脂针祛双下巴
轮廓针	垫下巴,祛双下巴,瘦脸,光纤溶脂瘦脸,黄金微雕瘦脸,射频溶脂瘦脸,瘦脸针,激光溶脂瘦脸,热玛吉,玻尿酸垫下巴
微笑唇/M唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
太阳穴填充	面部轮廓,填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,自体脂肪丰太阳穴,玻尿酸祛法令纹
假体垫鼻基底	垫鼻基底,隆鼻,缩鼻头,缩鼻翼,玻尿酸垫鼻基底,假体垫鼻基底,自体脂肪垫鼻基底,膨体隆鼻,鼻综合
面部提升	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕,热玛吉
刷酸	祛痘,祛痘印,祛痘坑,果酸焕肤,点阵激光,微针美塑,红蓝光祛痘,无针水光,菲洛嘉
乔雅登	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
私密漂红	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
磨骨手术	面部轮廓,缩下颌角,瘦脸,下颌角整形,吸脂瘦下颌缘,光纤溶脂瘦下颌缘,肉毒素瘦下颌缘,瘦脸针
切眉	上眼睑提升,双眼皮,上眼睑提肌,切开双眼皮,眼综合,面部线雕,热玛吉
婴儿针	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入
硅胶垫下巴	垫下巴,祛双下巴,瘦脸,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴
祛痘祛痘印	祛痘,祛痘印,祛痘坑,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光
人中缩短术	人中缩短,人中延长,玻尿酸丰唇,m唇,嘴角上扬,厚唇改薄,微笑唇
熊猫针	祛眼袋,祛黑眼圈,填充泪沟,祛眼纹,外切去眼袋,内切祛眼袋,玻尿酸祛黑眼圈,激光祛黑眼圈,玻尿酸填充泪沟
祛黑眼圈	祛黑眼圈,祛眼袋,填充泪沟,祛眼纹,玻尿酸祛黑眼圈,激光祛黑眼圈,自体脂肪祛黑眼圈,外切去眼袋,内切祛眼袋,玻尿酸填充泪沟
海薇	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
颈纹	祛颈纹,肉毒素祛颈纹,埋线祛颈纹,玻尿酸祛颈纹,自体脂肪祛颈纹
黑头	祛黑头,补水,祛痘,小气泡,水氧活肤,无针水光,玻尿酸导入,果酸焕肤,光子嫩肤,红蓝光祛痘
洗眉	修眉,生眉毛,祛眉间纹,上眼睑提升,皮秒,半永久纹眉,植眉,注射祛眉间纹,切眉
埋线	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,热玛吉
肉毒素	祛面部细纹,瘦脸,瘦大腿,瘦小腿,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹,瘦脸针,瘦腿针
微笑唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
小腿吸脂	瘦腿,瘦大腿,瘦小腿,瘦腿针,激光溶脂瘦腿,光纤溶脂瘦腿,黄金微雕,冷冻溶脂瘦腿
私密	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
润百颜	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
开内眼角	双眼皮,开眼角,开外眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
开外眼角	双眼皮,开眼角,开内眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
润百颜黑金	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
吸脂瘦手臂	瘦手臂,瘦脸,瘦大腿,瘦小腿,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦全身,吸脂瘦脸,瘦腿针,瘦脸针
乳晕漂红	乳晕美化,隆胸,乳晕淡化,注射丰乳晕,假体隆胸,自体脂肪隆胸,胸部护理
提眉术	上眼睑提升,切眉,植眉,上眼睑提肌,切开双眼皮,眼综合,面部线雕,热玛吉
玻尿酸填充泪沟	填充泪沟,祛黑眼圈,祛眼袋,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈,玻尿酸填充卧蚕
无针水光	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针
鼻 	隆鼻,缩鼻头,缩鼻翼,玻尿酸隆鼻,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
童颜针	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针,玻尿酸丰额头
隐形牙齿矫正	牙齿矫正,牙齿护理,牙齿清洁,金属托槽矫正,牙齿半隐形矫正,超声波洗牙,冷光美白,根管治疗,烤瓷牙,种植牙
卧蚕	填充卧蚕,祛黑眼圈,祛眼袋,玻尿酸填充卧蚕,真皮填充卧蚕,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈
植发际线	生发际线,生眉毛,植发,植发,植眉,植鬓角,半永久纹眉,洗眉
补牙	牙齿矫正,牙齿护理,牙齿清洁,冷光美白,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙,牙齿种植
大腿吸脂	瘦腿,瘦大腿,瘦小腿,瘦腿针,激光溶脂瘦腿,光纤溶脂瘦腿,黄金微雕,冷冻溶脂瘦腿
m唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
去黑眼圈	祛黑眼圈,填充泪沟,激光祛黑眼圈,白瓷娃娃,皮秒,玻尿酸祛黑眼圈
半永久纹眉	修眉,生眉毛,祛眉间纹,上眼睑提升,皮秒,植眉,注射祛眉间纹,切眉
种植牙	牙齿矫正,牙齿护理,牙齿清洁,种植牙,冷光美白,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙
妊娠纹	祛妊娠纹,激光祛妊娠纹,黄金微针祛妊娠纹,射频提升,热玛吉,热拉提
阴道紧缩	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
漂红	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
颧骨降低	面部轮廓,颧骨内推,垫下巴,瘦脸,颧骨降低,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴
热提拉	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,射频紧肤,面部线雕,黄金微针, 小切口提升
缩小毛孔	缩毛孔,祛痘印,祛斑,黑脸娃娃,微针,点阵激光,光子嫩肤,蜂巢皮秒,超皮秒
自体脂肪	填充苹果肌,填充泪沟,丰太阳穴,丰额头,自体脂肪填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
全身吸脂	瘦全身,瘦大腿,瘦小腿,瘦脸,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦脸,瘦脸针,瘦腿针
嘟嘟唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
抬头纹	祛抬头纹,祛面部细纹,祛眼纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹,水光针
下眼睑下至	下眼睑下至,开内眼角,开外眼角,切开双眼皮,埋线双眼皮,上眼睑提肌
拉皮手术	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕,热玛吉
射频溶脂	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,光纤溶脂,吸脂瘦全身,激光溶脂瘦全身,冷冻溶脂,黄金微雕
填充泪沟	填充泪沟,祛黑眼圈,祛眼袋,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈,玻尿酸填充卧蚕
胸部下垂矫正	隆胸,胸部提升,乳晕美化,假体隆胸,硅胶隆胸,自体脂肪隆胸,复合隆胸,乳房提升
乔雅登极致	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
唇 	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
全切双眼皮	双眼皮,开眼角,开内眼角,开外眼角,眼综合,定点双眼皮,埋线双眼皮,双眼皮修复
正颌	颌面矫正,牙齿矫正,颌面正畸,颌面修复,金属托槽矫正,牙齿自锁托槽矫正,牙齿隐形矫正 ,牙齿半隐形矫正
小拉皮	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕,热玛吉
针清	祛痘,祛痘印,祛痘坑,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光
冰点脱毛	脱毛,脱手脚毛,脱腋毛,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛
瘦肩	瘦肩,瘦脸,瘦大腿,瘦小腿,瘦腿针,瘦脸针,吸脂瘦腿,光纤溶脂瘦脸,隔空溶脂瘦腿
双下巴	祛双下巴,吸脂祛双下巴,激光溶脂祛双下巴,射频溶脂祛双下巴,光纤溶脂祛双下巴
自体脂肪全面部填充	填充苹果肌,填充泪沟,丰太阳穴,丰额头,玻尿酸填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
玻尿酸丰太阳穴	面部轮廓,丰太阳穴,丰额头,玻尿酸填充面部,玻尿酸隆鼻,自体脂肪丰苹果肌,自体脂肪丰太阳穴,自体脂肪填充泪沟
缩小鼻头	隆鼻,缩鼻头,缩鼻翼,耳软骨垫鼻头,手术延长鼻小柱,鼻中隔软骨垫鼻头,肉毒素缩鼻头,假体隆鼻,肋软骨隆鼻
全身脱毛	脱全身毛发,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛,激光脱唇毛,激光脱私处毛发
胸	隆胸,胸部护理,乳晕美化,胸部提升,自体脂肪隆胸,硅胶隆胸,综合隆胸,胸部护理,乳房提升
一针降颧骨	面部轮廓,颧骨内推,垫下巴,瘦脸,颧骨降低,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴
眉弓	面部轮廓,垫眉弓,隆鼻,假体垫眉弓,自体脂肪垫眉弓,膨体垫眉弓,硅胶垫眉弓,玻尿酸垫眉弓
面吸	瘦脸,光纤溶脂瘦脸,黄金微雕瘦脸,射频溶脂瘦脸,瘦脸针,激光溶脂瘦脸,溶脂针祛双下巴,吸脂瘦脸
凸嘴矫正	牙齿矫正,牙齿美白,牙齿清洁,金属托槽矫正,牙齿自锁托槽矫正,牙齿隐形矫正 ,牙齿半隐形矫正,超声波洗牙,冷光美白
威塑吸脂	瘦全身,瘦大腿,瘦小腿,瘦腿针,射频溶脂瘦全身,隔空溶脂瘦全身,吸脂瘦全身,激光溶脂瘦全身
双美胶原蛋白	祛黑眼圈,填充泪沟,激光祛黑眼圈,白瓷娃娃,皮秒,玻尿酸祛黑眼圈,玻尿酸填充泪沟,玻尿酸祛颈纹
私密紧致	私密健康,私密紧致,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
脱发际线	脱手脚毛,脱腋毛,脱全身毛发,激光脱发际线,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛,激光脱唇毛,激光脱私处毛发
激光祛疤	祛疤,祛痣,美白,注射祛疤,点阵激光,复合彩光,蜂巢皮秒,超皮秒,像素激光
拉皮手术提升	紧致提升,上眼睑提升,颈部提升,热玛吉,射频提升,超声刀,热拉提,面部线雕,黄金微针
冷冻溶脂	瘦全身,瘦脸,瘦腰腹,瘦腿,瘦手臂,冷冻溶脂瘦小腿,冷冻溶脂瘦大腿,冷冻溶脂瘦腰腹,冷冻溶脂瘦手臂,吸脂瘦全身
疤痕	祛疤,祛痣,美白,注射祛疤,点阵激光,复合彩光,蜂巢皮秒,超皮秒,像素激光
肋软骨隆鼻	隆鼻,缩鼻头,缩鼻翼,耳软骨垫鼻头,手术延长鼻小柱,鼻中隔软骨垫鼻头,肉毒素缩鼻头,假体隆鼻,肋软骨隆鼻
私密脱毛	脱手脚毛,脱腋毛,脱全身毛发,激光脱发际线,激光脱全身毛发,激光脱腿毛,激光脱臂毛,激光脱腋毛,激光脱唇毛,激光脱私处毛发
眼部热玛吉	紧致提升,上眼睑提升,颈部提升,小切口提升,热玛吉,射频提升,超声刀,射频紧肤,面部线雕,黄金微针, 注射祛鱼尾纹
脂肪胶	填充苹果肌,填充泪沟,丰太阳穴,丰额头,自体脂肪填充面部,自体脂肪丰苹果肌,自体脂肪丰额头,自体脂肪丰太阳穴,自体脂肪填充泪沟
润月雅水光针	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针
改善肤质	美白,祛斑,祛痘印,祛痘坑,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光
乳头缩小	乳头美化,乳头漂红,乳头内陷矫正,乳头再造 ,注射丰乳头,乳房提升
小棕瓶	美白,祛斑,祛痘印,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
衡力	祛面部细纹,祛眼纹,瘦脸,瘦大腿,瘦小腿,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹,瘦脸针,瘦腿针
激光点痣	祛痣,切痣,点阵激光,蜂巢皮秒,超皮秒
英诺	美白,祛斑,祛痘印,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
嘴角上扬术	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
吸脂瘦全身	瘦全身,瘦大腿,瘦小腿,瘦脸,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦脸,瘦脸针,瘦腿针
英诺小棕瓶	美白,祛斑,祛痘印,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
玻尿酸除法令纹	祛法令纹,垫鼻基底,玻尿酸祛法令纹,自体脂肪祛法令纹,假体祛法令纹,肉毒素祛法令纹
下颌角整形	面部轮廓,缩下颌角,垫下巴,丰太阳穴,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴,自体脂肪丰面颊
玻尿酸下巴	垫下巴,祛双下巴,瘦脸,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴
红蓝光祛痘	祛痘,祛痘印,祛痘坑,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光,红蓝光祛痘
酷塑	瘦全身,瘦大腿,瘦小腿,光纤溶脂,吸脂瘦全身,激光溶脂瘦全身,冷冻溶脂,黄金微雕,瘦腿针
肉毒素瘦脸	瘦脸,缩咬肌,光纤溶脂瘦脸,吸脂瘦脸,射频溶脂瘦脸,激光溶脂瘦脸
PRP自体血清美肤	补水,美白,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针,白瓷娃娃
去疤痕	祛疤,祛痣,注射祛疤,点阵激光,复合彩光,蜂巢皮秒,超皮秒,像素激光
去痣	祛痣,美白,祛痘印,激光点痣,切痣,点阵激光,蜂巢皮秒,超皮秒,光子嫩肤
超体隆鼻	隆鼻,缩鼻头,缩鼻翼,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
伊肤泉	祛痘,祛痘印,祛痘坑,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光,红蓝光祛痘
毛孔	缩毛孔,祛痘印,祛斑,黑脸娃娃,微针,点阵激光,光子嫩肤,蜂巢皮秒,超皮秒,白瓷娃娃,黄金微针
苹果肌	填充苹果肌,玻尿酸填充苹果肌 ,自体脂肪填充苹果肌,胶原蛋白填充苹果肌
种植睫毛	生睫毛,半永久睫毛线,睫毛增长 ,植发,植眉,半永久纹眉
种植眉毛	生眉毛,祛眉间纹,上眼睑提升,半永久纹眉,植眉,玻尿酸祛眉间纹,切眉,洗眉
全身美白	美白,祛斑,祛痘印,美白针,蜂巢皮秒,超皮秒,光子嫩肤, 彩光嫩肤,白瓷娃娃,黑脸娃娃
红血丝	祛红血丝,激光祛红血丝,光子嫩肤, 彩光嫩肤,蜂巢皮秒,超皮秒
腿部吸脂	瘦大腿,瘦小腿,瘦手臂,吸脂瘦腿,吸脂瘦小腿,吸脂瘦大腿,瘦腿针,冷冻溶脂瘦腿,光纤溶脂瘦腿
正颌手术	颌面矫正,牙齿矫正,颌面正畸,颌面修复,金属托槽矫正,牙齿自锁托槽矫正,牙齿隐形矫正 ,牙齿半隐形矫正
人中	人中缩短,人中延长,玻尿酸丰唇,m唇,嘴角上扬,厚唇改薄,微笑唇
丝丽	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,自体脂肪丰太阳穴,玻尿酸祛法令纹
牙贴面	牙齿矫正,牙齿美白,牙齿清洁,种植牙,冷光美白,皓齿美白,瓷贴面,烤瓷牙,超声波洗牙
腰腹环吸	瘦腰腹,瘦腰部,瘦腹部,隔空溶脂瘦腰腹,激光溶脂瘦腰腹,冷冻溶脂瘦腰腹,吸脂瘦腰腹,射频溶脂瘦腰腹
肋骨隆鼻	隆鼻,缩鼻头,缩鼻翼,玻尿酸隆鼻,鼻综合,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
鼻基底凹陷	垫鼻基底,隆鼻,缩鼻头,缩鼻翼,玻尿酸垫鼻基底,假体垫鼻基底,自体脂肪垫鼻基底,膨体隆鼻,鼻综合
垫下巴	垫下巴,祛双下巴,瘦脸,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴,瘦脸针,吸脂瘦脸
牙齿隐形矫正	牙齿矫正,牙齿美白,牙齿清洁,金属托槽矫正,牙齿自锁托槽矫正,牙齿隐形矫正 ,牙齿半隐形矫正,超声波洗牙,冷光美白
鼻小柱延长	鼻小柱矫正,隆鼻,缩鼻翼,耳软骨垫鼻头,手术延长鼻小柱,鼻中隔软骨垫鼻头,假体隆鼻,肋软骨隆鼻
假体隆鼻	隆鼻,缩鼻头,缩鼻翼,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
鼻骨内推	缩鼻背,宽鼻矫正,缩鼻头,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
鼻翼	缩鼻翼,隆鼻,缩鼻头,埋线缩鼻翼,手术缩鼻翼,耳软骨垫鼻头,鼻小柱延长,鼻中隔延长,鼻综合
红蓝光	祛痘,祛痘印,祛痘坑,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,黄金微针,点阵激光
埋线减肥	瘦全身,瘦大腿,瘦小腿,光纤溶脂,吸脂瘦全身,激光溶脂瘦全身,冷冻溶脂,黄金微雕,瘦腿针
舒敏之星	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针
烤瓷牙	牙齿矫正,牙齿美白,牙齿清洁,牙齿护理,冷光美白,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙,牙齿种植
水光针注射	补水,祛眼纹,祛面部细纹,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针
抽脂瘦身	瘦全身,瘦大腿,瘦小腿,瘦脸,吸脂瘦大腿,吸脂瘦腰腹,吸脂瘦小腿,吸脂瘦手臂,吸脂瘦脸,瘦脸针,瘦腿针
婕尔	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹,玻尿酸隆鼻
美白嫩肤	美白,祛斑,祛痘印,美白针,蜂巢皮秒,超皮秒,激光祛斑, 彩光嫩肤,白瓷娃娃,黑脸娃娃,光子嫩肤
膨体隆鼻	隆鼻,缩鼻头,缩鼻翼,鼻综合,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
热拉提plus	紧致提升,上眼睑提升,颈部提升,热拉提,超声刀,射频提升,面部线雕,切眉,胶原蛋白祛颈纹
小气泡美肤	祛黑头,补水,祛痘,水氧活肤,无针水光,玻尿酸导入,果酸焕肤,光子嫩肤,红蓝光祛痘
牙齿瓷贴面	牙齿矫正,牙齿美白,牙齿清洁,冷光美白,皓齿美白,牙贴面,瓷贴面,烤瓷牙,超声波洗牙,牙齿种植
自体脂肪丰臀	丰臀,塑臀,假体丰臀,吸脂塑臀,吸脂塑臀,光纤溶脂塑臀
面部线雕	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,热玛吉
太阳穴	面部轮廓,丰太阳穴,玻尿酸丰太阳穴,自体脂肪丰太阳穴,假体丰太阳穴,胶原蛋白丰太阳穴
牙套	牙齿矫正,牙齿美白,牙齿清洁,金属托槽矫正,牙齿自锁托槽矫正,牙齿隐形矫正 ,牙齿半隐形矫正
手臂吸脂	瘦手臂,瘦身,祛副乳,光纤溶脂瘦手臂,吸脂瘦手臂,冷冻溶脂瘦手臂,射频溶脂瘦手臂,激光溶脂瘦手臂
腰腹抽脂	瘦腰腹,瘦腰部,瘦腹部,隔空溶脂瘦腰腹,激光溶脂瘦腰腹,冷冻溶脂瘦腰腹,吸脂瘦腰腹,射频溶脂瘦腰腹
隐形矫正	牙齿矫正,牙齿美白,牙齿清洁,金属托槽矫正,牙齿自锁托槽矫正,牙齿半隐形矫正,牙齿综合 ,牙齿侧舌矫正
内切祛眼袋	祛眼袋,填充泪沟,祛黑眼圈,祛眼纹,外切去眼袋,眶隔脂肪释放,玻尿酸填充泪沟,激光祛黑眼圈
欧洲之星	私密紧致,私密美化,私密超声提升,激光紧缩阴道,手术紧缩阴道,小阴唇整形,阴唇漂红,玻尿酸丰阴唇
瑞蓝	填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,玻尿酸祛法令纹
自体脂肪填充泪沟	填充泪沟,祛黑眼圈,祛眼袋,玻尿酸填充泪沟,自体脂肪填充泪沟,激光去黑眼圈,玻尿酸填充卧蚕
爱贝芙	隆鼻,缩鼻头,缩鼻翼,玻尿酸隆鼻,鼻综合,肋软骨隆鼻,硅胶隆鼻,膨体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
近视矫正	近视,全飞秒激光术,绿飞秒激光术,半飞秒激光术,OK镜近视矫正,视网膜检测
肉毒素去抬头纹	祛抬头纹,祛眼纹,祛眉间纹,玻尿酸祛抬头纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,热玛吉
祛抬头纹	祛抬头纹,祛面部细纹,祛眼纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹,水光针
祛眼纹	祛抬头纹,祛面部细纹,祛眼纹,祛眉间纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹
祛眉间纹	祛面部细纹,祛眼纹,祛眉间纹,肉毒素祛眉间纹,肉毒素祛面部细纹,注射祛鱼尾纹,肉毒素祛抬头纹,水光针
祛法令纹	祛法令纹,垫鼻基底,玻尿酸祛法令纹,自体脂肪祛法令纹,假体祛法令纹,肉毒素祛法令纹,玻尿酸垫鼻基底,假体垫鼻基底
控油	控油,补水,小气泡,果酸焕肤,水光针,无针水光,婴儿针,微针水光,水氧活肤,玻尿酸精华导入
补水	补水,美白,菲洛嘉,无针水光,微针水光,水氧活肤,玻尿酸精华导入,微针水光,婴儿针,白瓷娃娃
缩毛孔	缩毛孔,祛痘印,祛斑,黑脸娃娃,微针,点阵激光,光子嫩肤,蜂巢皮秒,超皮秒,白瓷娃娃,黄金微针
祛黑头	祛黑头,补水,祛痘,小气泡,水氧活肤,无针水光,玻尿酸导入,果酸焕肤,光子嫩肤,红蓝光祛痘
祛痣	祛痣,美白,祛痘印,激光点痣,切痣,点阵激光,蜂巢皮秒,超皮秒,光子嫩肤
上眼睑提升	上眼睑提升,切眉,双眼皮,眼综合,定点双眼皮,埋线双眼皮,上眼睑提肌,双眼皮修复
缩眼距	缩眼距,双眼皮,开眼角,开内眼角,开外眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
大眼睛	大眼睛,双眼皮,开眼角,开内眼角,开外眼角,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮,双眼皮修复
眼角提升	眼角提升,双眼皮,切眉,上眼睑提肌,眼综合,定点双眼皮,埋线双眼皮,切开双眼皮
鼻部缩短	鼻部缩短,隆鼻,长鼻矫正,耳软骨垫鼻头,鼻中隔软骨垫鼻头,假体隆鼻,肋软骨隆鼻
鼻中隔延长	鼻中隔延长,隆鼻,缩鼻头,鼻中隔软骨垫鼻头,鼻综合,肋软骨隆鼻,硅胶隆鼻,假体隆鼻,耳软骨垫鼻头,手术缩鼻翼,鼻部修复
缩下颌角	面部轮廓,缩下颌角,垫下巴,丰太阳穴,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴,自体脂肪丰面颊
缩短下巴	缩短下巴,垫下巴,玻尿酸垫下巴,假体垫下巴,自体脂肪垫下巴,膨体垫下巴
颧骨内推	面部轮廓,颧骨内推,垫下巴,瘦脸,颧骨降低,下颌角切除,瘦脸针,玻尿酸丰太阳穴,假体垫下巴
丰太阳穴	面部轮廓,填充苹果肌,丰太阳穴,垫下巴,玻尿酸垫下巴,玻尿酸填充苹果肌,玻尿酸丰太阳穴,自体脂肪丰太阳穴,玻尿酸祛法令纹
薄唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
厚唇	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
嘴角上扬	丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
缩窄下巴	缩窄下巴,垫下巴,宽下巴矫正,假体垫下巴,玻尿酸垫下巴,自体脂肪丰下巴,玻尿酸垫下巴,膨体垫下巴
人中延长	人中延长,人中缩短,玻尿酸丰唇,m唇,嘴角上扬,厚唇改薄,微笑唇
缩咬肌	缩咬肌,瘦脸,瘦脸针,光纤溶脂瘦脸,吸脂瘦脸,激光溶脂瘦脸,黄金微雕
修眉	修眉,生眉毛,祛眉间纹,上眼睑提升,半永久纹眉,植眉,注射祛眉间纹,切眉
面部消脂	面部消脂,瘦下颌缘,瘦脸,吸脂瘦脸,肉毒素瘦下颌缘,瘦脸针,光纤溶脂瘦脸,激光溶脂瘦脸
眼部护理	眼部护理,补水,祛眼纹,水光针,菲洛嘉,无针水光,热玛吉,注射祛鱼尾纹
紧致提升	紧致提升,上眼睑提升,颈部提升,热拉提,射频提升,超声刀,射频紧肤,面部线雕,热玛吉,黄金微针
嫩唇	嫩唇,丰唇,嘴角上扬,薄唇,玻尿酸丰唇,m唇,微笑唇,漂唇,嘟嘟唇,厚唇改薄
丰面颊	面部轮廓,丰面颊,垫下巴,丰太阳穴,瘦脸针,玻尿酸丰太阳穴,假体垫下巴,自体脂肪丰面颊,玻尿酸丰面颊""".decode("utf-8")


def split_words():
	kernel_word_and_thesaurus = dict()
	words_list = need_split_words.split("\n")
	for line_words in words_list:
		if not line_words:
			continue
		line_words_list = line_words.split("\t")
		kernel_word_and_thesaurus[line_words_list[0]] = line_words_list[1].split(",")
	return kernel_word_and_thesaurus


class Command(BaseCommand):
	""" 手动初始化搜索 联想词"""
	def handle(self, *args, **options):
		kernel_word_and_thesaurus = split_words()
		for kernel_word, thesaurus_list in kernel_word_and_thesaurus.items():
			print u"正在添加 %s 核心词" % kernel_word
			wg = WordGroup()
			wg.is_deleted = 0
			wg.save()

			rw = RecommendWords()
			rw.word_group_id = wg.id
			rw.is_deleted = 0
			rw.is_kernel = 1
			rw.thesaurus = kernel_word
			rw.save()

			for thesaurus in thesaurus_list:
				rw = RecommendWords()
				rw.word_group_id = wg.id
				rw.is_deleted = 0
				rw.is_kernel = 0
				rw.thesaurus = thesaurus
				rw.save()

		print u"恭喜，核心词添加完成！"