#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/6/3
import json
from django.core.management import BaseCommand

from api.models.servicehome import ServiceHomeOperation, \
    ServiceRelatedOperation


class Command(BaseCommand):
    def handle(self, *args, **options):
        for servicehome in ServiceHomeOperation.objects.all():
            count = 0
            details = json.loads(servicehome.details) if servicehome.details else []
            for element in details:
                count += 1
                if not element['id'] or not element['img']:
                    continue

                ServiceRelatedOperation.objects.update_or_create(
                    servicehome_id=servicehome.id,
                    position=count,
                    defaults={'image': element['img'], 'jump_id': element['id']}
                )