# coding=utf-8

from django.core.management import BaseCommand

from api.models import Service, SericeNameChangeLog, ServiceItem, ServiceItemKey, AttrOptions, AttrNameChangeLog
from rpc.tool.log_tool import info_logger


class Command(BaseCommand):
    """
    更改service_name
    python manage.py change_service_name
    """

    def handle(self, *args, **options):
        # service_list = Service.objects.filter(doctor__hospital__city_id='shanghai').all()  # 筛选医生医院在上海的美购
        service_list = Service.objects.all()
        for s in service_list:
            try:
                old_short_description = s.short_description
                doctor = s.doctor
                service_id = s.id
                if ('美白针' in s.short_description) or ('溶脂针' in s.short_description):
                    s.short_description = s.short_description.replace('美白针', '美白嫩肤')
                    s.short_description = s.short_description.replace('溶脂针', '溶脂瘦脸')
                    change_short_description = s.short_description
                    serice_name_change_log = SericeNameChangeLog()  # 备份更改数据
                    serice_name_change_log.service_id = service_id
                    serice_name_change_log.short_description = old_short_description
                    serice_name_change_log.change_short_description = change_short_description
                    serice_name_change_log.doctor = doctor
                    serice_name_change_log.save()  # 保存日志
                else:
                    pass
                serviceitem_list = ServiceItem.objects.filter(service=s).all()
                attr_option_id_list = ServiceItemKey.objects.filter(serviceitem__in=serviceitem_list).values_list(
                    'serviceattroption', flat=True)
                attr_options_list = AttrOptions.objects.filter(id__in=attr_option_id_list)  # 筛选SKU
                for a in attr_options_list:  # 检索SKU
                    if ('美白针' in a.name) or ('溶脂针' in a.name):
                        attr_name_change_log = AttrNameChangeLog()
                        attr_old_name = a.name
                        attr_id = a.id
                        a.name = a.name.replace('美白针', '美白嫩肤')
                        a.name = a.name.replace('溶脂针', '溶脂瘦脸')
                        attr_name_change_log.attr_name = attr_old_name
                        attr_name_change_log.change_attr_name = a.name
                        attr_name_change_log.attr_id = attr_id
                        attr_name_change_log.service_id = service_id
                        attr_name_change_log.doctor = doctor
                        attr_name_change_log.save()  # 保存日志
                        a.save(update_fields=['name'])  # 保存修改
                if s.doctor.hospital.city_id == 'shanghai':  # 单独处理上海的瘦脸针及水光针
                    # print service_id
                    if ('水光针' in s.short_description) or ('瘦脸针' in s.short_description):
                        s.short_description = s.short_description.replace('水光针', '水光补水')
                        s.short_description = s.short_description.replace('瘦脸针', '瘦脸除皱')
                        change_short_description = s.short_description
                        serice_name_change_log = SericeNameChangeLog()  # 备份更改数据
                        serice_name_change_log.service_id = service_id
                        serice_name_change_log.short_description = old_short_description
                        serice_name_change_log.change_short_description = change_short_description
                        serice_name_change_log.doctor = doctor
                        serice_name_change_log.save()  # 保存日志
                    else:
                        pass
                    serviceitem_list = ServiceItem.objects.filter(service=s).all()
                    attr_option_id_list = ServiceItemKey.objects.filter(serviceitem__in=serviceitem_list).values_list(
                        'serviceattroption', flat=True)
                    attr_options_list = AttrOptions.objects.filter(id__in=attr_option_id_list)  # 筛选SKU
                    for a in attr_options_list:  # 检索SKU
                        if ('水光针' in a.name) or ('瘦脸针' in a.name):
                            attr_name_change_log = AttrNameChangeLog()
                            attr_old_name = a.name
                            attr_id = a.id
                            a.name = a.name.replace('水光针', '水光补水')
                            a.name = a.name.replace('瘦脸针', '瘦脸除皱')
                            attr_name_change_log.attr_name = attr_old_name
                            attr_name_change_log.change_attr_name = a.name
                            attr_name_change_log.attr_id = attr_id
                            attr_name_change_log.service_id = service_id
                            attr_name_change_log.doctor = doctor
                            attr_name_change_log.save()  # 保存日志
                            a.save(update_fields=['name'])  # 保存修改
                else:
                    pass
                s.save(update_fields=['short_description'])
            except Exception as e:
                info_logger.info(str(e))
