#!/usr/bin/env python
# -*- coding:utf-8 -*-
"""
处理测肤后台配置的  眼袋、法令纹  的对应值
"""
from __future__ import absolute_import, division, with_statement
from django.core.management import BaseCommand
from api.models.face.skin_conf import SkinType
from gm_types.gaia import KS_SKIN_ALL_TYPE


class Command(BaseCommand):

    def handle(self, *args, **options):
        print("Start")
        skin_confs = SkinType.objects.filter(type_content__in=[KS_SKIN_ALL_TYPE.EYE_POUCH, KS_SKIN_ALL_TYPE.NASOLABIAL_FOLD])

        val_map = {0: 1, 1: 2, 2: 0}

        for skin_conf in skin_confs:
            new_type_value = val_map.get(skin_conf.type_value, None)
            if new_type_value is None:
                continue

            skin_conf.type_value = new_type_value
            skin_conf.save()

        print("Done")
