# -*- coding:utf-8 -*-
"""
更新feed配置表中的 模板脸id
"""
from django.core.management import BaseCommand
from api.models.slide import FeedOperateV2
from gm_types.gaia import PLASTICFACESTYLE
from api.models.face.cheek_style import CheekStyle


class Command(BaseCommand):
    def handle(self, *args, **options):

        names = []
        for template_id, name in PLASTICFACESTYLE.choices:
            names.append(name)

        name_id_dic = dict(CheekStyle.objects.filter(name__in=names).values_list("name", "id"))

        for template_id, name in PLASTICFACESTYLE.choices:
            _id = name_id_dic.get(name)
            if not _id:
                continue

            FeedOperateV2.objects.filter(plastic_template=str(template_id)).update(plastic_template=str(_id))

