#!/usr/bin/env python
# -*- coding:utf-8 -*-

from __future__ import absolute_import, division, with_statement

from django.core.management import BaseCommand

from gm_types.gaia import PAYMENT_CHANNEL

from api.models import Order, Settlement, SettlementItem
from pay.models import PaymentOrder
from pay.tool.purchase_tool import _do_settlement_paid

order_list = [

]

settlement_list = [

]


def check_order_status_by_order_id(order_list):
    for order_id in order_list:
        settlement_item = SettlementItem.objects.get(order_id=order_id)
        settlement = Settlement.objects.get(id=settlement_item.settlement_id)
        payment_channel = PAYMENT_CHANNEL.ALIPAY
        pay_time = PaymentOrder.objects.filter(orders=order_id)[0].paid_time
        _do_settlement_paid(settlement, payment_channel, pay_time)
        print("Done")


def check_order_status_by_settlement_id(settlement_list):
    for settlement_id in settlement_list:
        settlement = Settlement.objects.get(id=settlement_id)
        payment_channel = PAYMENT_CHANNEL.ALIPAY
        settlement_item = SettlementItem.objects.filter(settlement_id=settlement_id).first()
        pay_time = PaymentOrder.objects.filter(orders=settlement_item.order_id)[0].paid_time
        _do_settlement_paid(settlement, payment_channel, pay_time)

    print("Done")


class Command(BaseCommand):
    """
    python manage.py deal_pc_alipay --type order  # 根据订单id
    python manage.py deal_pc_alipay --type settlement  # 根据结算单id
    """

    def add_arguments(self, parser):
        parser.add_argument(
            '--type', type=str, default=None
        )

    def handle(self, type, *args, **options):
        if type == 'order':
            check_order_status_by_order_id(order_list)

        elif type == 'settlement':
            check_order_status_by_settlement_id(settlement_list)



