# coding: utf-8

from django.core.management import BaseCommand
from relation.models import UserTagRelation

class Command(BaseCommand):

    def handle(self, *args, **options):
        all_records = UserTagRelation.objects.all()
        users = (record.user_id for record in all_records)
        for user in users:
            user_records = all_records.filter(user_id=user)
            all_tags = (record.related_tag_id for record in user_records)
            for tag in all_tags:
                records = user_records.filter(related_tag_id=tag, tag_type='0')
                if records.count() > 1:
                    print 'repetitive user and tag:', user, tag
                    point = 1
                    while point < records.count():
                        records[point].delete()
