# -*- coding:utf-8 -*-

from django.core.management import BaseCommand
from django.db import transaction

from api.models import Tag, SideSkidCategory
from api.models import TAG_TYPE


class Command(BaseCommand):
    def handle(self, *args, **options):
        tags_name = [u'齿科', u'瘦身', u'海外', u'抗衰', u'美肤', u'微整', u'眼眉', u'胸部', u'毛发', u'口唇', u'修复', u'半永久', u'鼻部', u'轮廓']
        tags = Tag.objects.filter(name__in=tags_name, tag_type=TAG_TYPE.BODY_PART)
        for tag in tags:
            print tag.name
            with transaction.atomic():
                obj = SideSkidCategory.objects.create(
                    name=tag.name,
                    is_online=True,
                )
                obj.tags.add(tag)
