# coding: utf-8

from django.core.management import BaseCommand

from gm_types.gaia import SERVICE_FLAG

from lasker.models import AwardResult
from api.models import Hospital, Doctor


doctor_id2honor_name = {
    "fb2d63e9a8b444b6ad9733d0791f72ab": u"金牌脂肪管理医生",
    "xurongyang": u"金牌鼻部整形医生",
    "c59cf06c4f2211e6a62a00163e002fb3": u"金牌鼻部整形医生",
    "DRlijing": u"金牌鼻部整形医生",
    "liuxiaowei": u"金牌口碑整形医生",
    "6ca9d1f0c87d4d0288aa854f6c9b2cbe": u"金牌颌面整形医生",
    "326d7cf09b134eba9aba2f4be7a9dd93": u"金牌眼部整形医生",
    "chentingting": u"2019-年度优秀脂肪管理医生",         # 测试数据
}
hospital_id2honor_name = {
    "fb38be6e52b34b6d8efe7a30d2c93022": u"金牌口碑整形机构",
    "BJYXYLMRYY": u"金牌口碑整形机构",
    "shenzhenfutianzhongxiyijiehe": u"金牌口碑整形机构",
    "c6f23f32267e48708a21d1768a67b4f7": u"金牌口碑整形机构",
    "d9c37fc0f01c41058c1d3d94b6849276": u"金牌眼部整形机构",
    "ff9f5211f85f4f0686ac46b749f39e69": u"金牌口碑整形机构",
    "szpcyy": u"金牌鼻部整形机构",
    "96ea37eef81d11e692f800163e000a4a": u"金牌人气整形机构奖",
    "shrayy": u"2019-年度优秀颌面整形机构",       # 测试数据
}


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        def offline_award_result(laureate_id, laureate_type, award_name, service_name, hospital_or_doctor_name):
            # 下线荣誉
            award_results = AwardResult.objects.filter(
                is_deleted=0,
                laureate_type=laureate_type,
                laureate_id=laureate_id,
                award_name=award_name
            )

            for award_result in award_results:
                award_result.is_deleted = 1
                award_result.save()
                print "Offline  %s  %s   Award_name %s" % (service_name, hospital_or_doctor_name, award_result.award_name)

        # 下线机构和 机构管理相关 荣誉
        for hospital_id, honor_name in hospital_id2honor_name.items():
            hospital_info = Hospital.objects.filter(id=hospital_id).first()
            if hospital_info:
                offline_award_result(hospital_id, SERVICE_FLAG.HOSPITAL, honor_name, "Hospital", hospital_info.name)

                officer = hospital_info.officer
                if officer:
                    # 如果机构管理者 有相关荣誉也下线
                    offline_award_result(officer.id, SERVICE_FLAG.HOSPITAL, honor_name, "Hospital", hospital_info.name)

        # 医生荣誉下线
        for doctor_id, honor_name in doctor_id2honor_name.items():
            doctor_info = Doctor.objects.filter(id=doctor_id).first()
            if doctor_info:
                offline_award_result(doctor_info.id, SERVICE_FLAG.DOCTOR, honor_name, "Doctor", doctor_info.name)
        print "Success Offline Award Result"
