# coding=utf-8
import datetime
import json

from django.core.management import BaseCommand
from django.db import transaction

from api.models import OrderExtra, Order
from pay.models import ServiceSnapshot
from rpc.context import get_rpc_remote_invoker


class Command(BaseCommand):
    """
    批量处理订单
    python manage.py change_zone_type
    """

    def handle(self, *args, **options):
        rpc_invoker = get_rpc_remote_invoker()

        # current_month_first_day = datetime.date.today().replace(day=20)
        # order_ids = list(OrderExtra.objects.filter(promotion_type=u'霸王餐').values_list('order_id', flat=True))
        # orders = Order.objects.filter(id__in=order_ids, created_time__gte=current_month_first_day)
        # new_order_ids = list(orders.values_list('id', flat=True))

        new_order_ids = ["4688080250",
                         "5127613713",
                         "3544388986",
                         "4873000026",
                         "3832141394",
                         "4845146821",
                         "8150806188",
                         "4824561006",
                         "2409548642",
                         "3042237224",
                         "7273699200",
                         "1184862175",
                         "5249483806",
                         "7342376285",
                         "7318401691",
                         "5763664104",
                         "1826348075",
                         "7036709825",
                         "9919535076",
                         "9061026199",
                         "8949193382",
                         "7881104037",
                         "6926610378",
                         "4182990511",
                         "9468602957",
                         "7370422245",
                         "1357127284",
                         "1887877979",
                         "6111173763",
                         "5861955280",
                         "6488324007",
                         "5639057201",
                         "4725479201",
                         "9940363551",
                         "6983143422",
                         "2724101676",
                         "7794933386",
                         "2190322095",
                         "6994002039",
                         "3443192269",
                         "4299652277",
                         "5218085685",
                         "3985030017",
                         "7488399899",
                         "6958125932",
                         "9630717613",
                         "9924341850",
                         "6118031417",
                         "9950098592",
                         "8211970943",
                         "4595325089",
                         "2679575729",
                         "6384518408",
                         "3459573474",
                         "1371154141",
                         "9994868180",
                         "1556232700",
                         "1782336429",
                         "7696082511",
                         "8743236010",
                         "7731368308",
                         "1949963653",
                         "1841704099",
                         "3555880489",
                         "4138271388",
                         "4821016739",
                         "8083984699",
                         "9983887356",
                         "7014180640",
                         "9693214133",
                         "5074654085",
                         "3512566575",
                         "4912539315",
                         "2221294737",
                         "2888503468",
                         "2870530318",
                         "7859332319",
                         "8851724757",
                         "9331025799",
                         "5026989551",
                         "2393342712",
                         "4684286758",
                         "8084225763",
                         "8272248809",
                         "1202059290",
                         "3120687522",
                         "3010198560",
                         "3052708412",
                         "7972459763",
                         "7592677634",
                         "3198514791",
                         "1665239794",
                         "3719219249",
                         "3894881943",
                         "7111437642",
                         "9265018541",
                         "7479986512",
                         "3871275155",
                         "8019244503",
                         "3499124906",
                         "7269424671",
                         "2788907909",
                         "2038305953",
                         "8389877380",
                         "4647622931",
                         "7107251701",
                         "7829535733",
                         "2076456314",
                         "6329530844",
                         "8966774386",
                         "3678343275",
                         "4583592211",
                         "4967456625",
                         "1211834203",
                         "7346343414",
                         "9249621242",
                         "2622537779",
                         "5627024476",
                         "2196468869",
                         "2655050538",
                         "7296634359",
                         "9236672022",
                         "9416482718",
                         "7365183764",
                         "3866378583",
                         "3357553138",
                         "7607974363",
                         "9273339905",
                         "1307734716",
                         "7797293156",
                         "6298380512",
                         "9788577217",
                         "3208180730",
                         "6849863297",
                         "8302983399",
                         "9094715278",
                         "9237226045",
                         "6764359969",
                         "6899004690",
                         "3960526757",
                         "4602365382",
                         "1710843989",
                         "6522751175",
                         "8639577588",
                         "8302730488",
                         "3763042280",
                         "2947207477",
                         "1943829587",
                         "9837676526",
                         "2857418884",
                         "2736984569",
                         "5272009296",
                         "2863899222",
                         "5571531258",
                         "8381958081",
                         "5405678299",
                         "6566853268",
                         "6339154860",
                         "1210005858",
                         "2796841973",
                         "9182458160",
                         "9375032468",
                         "8227761548",
                         "1494663976",
                         "8857557382",
                         "8214460344",
                         "7322023238",
                         "2387481645",
                         "7126833982",
                         "2902935377",
                         "5917617666",
                         "5446120891",
                         "5442443111",
                         "9658463761",
                         "8502516079",
                         "3593363990",
                         "6700018753",
                         "4790148498",
                         "7926495530",
                         "5265109357",
                         "2321590079",
                         "3076602849",
                         "5530839070",
                         "2694506525",
                         "4892541125",
                         "7061423890",
                         "2526202263",
                         "3296119333",
                         "4389134624",
                         "3441229566",
                         "5659526144",
                         "3171682605",
                         "6531945787",
                         "9918882304",
                         "6985197213",
                         "4900325751",
                         "4059242600",
                         "7691014400",
                         "3006793490",
                         "2152385548",
                         "8729492432",
                         "9755712452",
                         "8750743263",
                         "6221181891",
                         "5078033679",
                         "1515206101",
                         "3714090127",
                         "4966661984",
                         "4875069943",
                         "3121737009",
                         "4719143067",
                         "5921667689",
                         "7105695907",
                         "8848854199",
                         "1579556082",
                         "9369153201",
                         "1365230327",
                         "4774722128",
                         "2972179196",
                         "7014219204",
                         "3857437959",
                         "3182084399",
                         "4260760456",
                         "3805813544",
                         "7906055367",
                         "6249528992",
                         "1182478720",
                         "1759144639",
                         "7516945919",
                         "5934615926",
                         "1568224864",
                         "4735735286",
                         "7863978472",
                         "3686834440",
                         "3217377398",
                         "9707072478",
                         "8998336147",
                         "8092593770",
                         "7336925850",
                         "7178627648",
                         "8624394141",
                         "6308854929",
                         "3950112928",
                         "6122422474",
                         "3575902793",
                         "2174664575",
                         "3334278957",
                         "3556136107",
                         "6996492279",
                         "8469722170",
                         "1074039393",
                         "2045310194",
                         "7056701192",
                         "4775323698",
                         "6164484108",
                         "6158949586",
                         "5063118042",
                         "5999933573",
                         "8161645939",
                         "7145546422",
                         "3334065246",
                         "8768318487",
                         "6504410084",
                         "1355636248",
                         "3700627382",
                         "4043261378",
                         "5244511893",
                         "3184187117",
                         "2638121545",
                         "2396745719",
                         "1999560374",
                         "9811892617",
                         "4837313013",
                         "2549646607",
                         "4162983809",
                         "2413983222",
                         "9890347494",
                         "8070642119",
                         "4938671830",
                         "1598976291",
                         "1123480449",
                         "3400029064",
                         "2548309253",
                         "9509481785",
                         "7848252863",
                         "3659782635",
                         "6299471794",
                         "1345212348",
                         "7401098670",
                         "6722779533",
                         "6308328793",
                         "8077457501",
                         "4731280761",
                         "5138042616",
                         "3124612682",
                         "8926141076",
                         "1673287462",
                         "8181250081",
                         "9451239540",
                         "8579354229",
                         "5533941423",
                         "5111676479",
                         "8857867105",
                         "3136689840",
                         "2303833280",
                         "5031330122",
                         "9802861624",
                         "5306829056",
                         "2770063149",
                         "4541301881",
                         "8348192278",
                         "7353590784",
                         "4591306176",
                         "2406037556",
                         "9683325024",
                         "2965456229",
                         "3627923181",
                         "5101051477",
                         "3144177700",
                         "7414377816",
                         "6497714075",
                         "3841643702",
                         "3045596284",
                         "8944336968",
                         "6244382442",
                         "4885851287",
                         "5815210869",
                         "6801376396",
                         "2054516691",
                         "7414813340",
                         "4441895915",
                         "7142112646",
                         "1963128156",
                         "4950299911",
                         "6230800201",
                         "1888530863",
                         "4312160827",
                         "9021503919",
                         "4295380232",
                         "6610056811",
                         "9510986509",
                         "3973451392",
                         "2930617342",
                         "1739808738",
                         "6288607088",
                         "8105957159",
                         "7986490751",
                         "6173582604",
                         "1240409842",
                         "5033291614",
                         "8001741229",
                         "5347994781",
                         "9471700453",
                         "1299845603",
                         "5683016476",
                         "9205389989",
                         "7726710065",
                         "6908307258",
                         "2089404224",
                         "4417443535",
                         "3282758792",
                         "4628528932", ]

        orders = Order.objects.filter(id__in=new_order_ids)

        servicesnapshot = ServiceSnapshot.objects.filter(order_id__in=new_order_ids)
        servicesnapshot_dict = {s.order_id: s for s in servicesnapshot}

        order_id2commodity_commission = rpc_invoker['poseidon/promotion/hera/commodity/commission'](order_ids=new_order_ids).unwrap()

        # rpc接口不会返回已经被删除了价格信息，并且只会返回最新的价格信息，但是下面的订单相关的价格已经被标记为删除不会被rpc返回
        # 需要根据从数据库行中的数据补全数据
        rpc_no_return_order_ids = ["2972179196", "6531945787", "3441229566", "2393342712"]

        for oid in rpc_no_return_order_ids:
            order_id2commodity_commission[oid] = {
                "activity_price": 399,
            }

        for order in orders:
            commodity_commission = order_id2commodity_commission.get(order.id)
            if not commodity_commission:
                print('订单 {} 没有对应数据，不处理'.format(order.id))
                continue
            try:
                order.service_price = commodity_commission.get("activity_price")
                order.discount = commodity_commission.get("activity_price")
                service_snapshot = json.loads(order.service_snapshot)
                service_snapshot["total_price"] = commodity_commission.get("activity_price")
                service_snapshot["discount"] = commodity_commission.get("activity_price")
                service_snapshot["pre_payment_price"] = commodity_commission.get("activity_price")
                service_snapshot["gengmei_price"] = commodity_commission.get("activity_price")

                order.service_snapshot = json.dumps(service_snapshot)
                order.save(update_fields=['service_price', 'discount', 'service_snapshot'])

                service_s = servicesnapshot_dict.get(order.id)
                service_s.total_price = commodity_commission.get("activity_price")
                service_s.discount = commodity_commission.get("activity_price")
                service_s.pre_payment_price = commodity_commission.get("activity_price")
                service_s.gengmei_price = commodity_commission.get("activity_price")

                service_s.save(update_fields=['gengmei_price', 'total_price', 'discount', 'pre_payment_price'])
            except Exception as e:
                print e
                print ('异常订单id{}'.format(order.id))
        print ('处理完毕----')

