# -*- coding: UTF-8 -*-

import re

from django.core.management import BaseCommand
from api.models import *
from doctor.models import Content as DoctorContent
from gm_upload.utils.qiniu_tool import QiniuTool
from pay.models.service import ServiceSnapshot

NEW_DOMAIN = u'http://hera.s.gmei.com/'


class Command(BaseCommand):
    def process_link_in_markdown(self, content):
        domains = [
            u'http://wanmeizhensuo.qiniudn.com/',
            u'http://imgcdn.wanmeizhensuo.com/',
            u'http://7d9qwy.com2.z0.glb.qiniucdn.com/',
            u'http://hera.s.gengmei.cc/',
            # u'http://hera.s.gmei.com/',
        ]
        for domain in domains:
            p = re.compile('(%s[a-z0-9A-Z\.\/\:]*?)[\ \)\n\"]' % (domain))
            urls = p.findall(content)
            for url in urls:
                if '-' in url:
                    continue
                path = url.replace(domain, '')
                ret, info = QiniuTool.bucket.stat('hera', path)
                if not ret:
                    print 'need copy'
                    QiniuTool.copy(path, path, 'wanmeizhensuo', 'hera')
                # if domain != u'http://hera.s.gengmei.cc/':
                new_url = url.replace(domain, NEW_DOMAIN)
                print url, path, new_url
                content = content.replace(url, new_url)
        return content

    def process_model(self, model, field):
        print model, field
        objs = model.objects.all()
        cnt = objs.count()
        bgn = 0
        step = 1000
        while bgn <= cnt:
            for obj in objs[bgn: bgn + step]:
                content = getattr(obj, field)
                new_content = self.process_link_in_markdown(content)
                if content != new_content:
                    print obj.id, model
                    print new_content
                    print '='*80
                    setattr(obj, field, new_content)
                    obj.save()
            __import__('time').sleep(1)
            bgn += step

    def process_suozhang(self):
        model = Problem
        field = 'answer'
        for obj in Problem.objects.filter(user_id=22):
            content = getattr(obj, field)
            new_content = self.process_link_in_markdown(content)
            if content != new_content:
                print obj.id
                print new_content
                print '='*80
                setattr(obj, field, new_content)
                obj.save()

    def handle(self, *args, **options):
        # self.process_model(Problem, 'answer')  # 所长发帖
        self.process_suozhang()  # 所长发帖
        self.process_model(Activity, 'description')  # 免费活动
        self.process_model(Service, 'detail_description')  # 美购.详细描述
        self.process_model(Service, 'special_remind')  # 美购.特别提醒
        self.process_model(Special, 'content')  # 专题.详情
        self.process_model(Campaign, 'rule')  # 活动.规则
        self.process_model(Coupon, 'announcement')  # 美券.特殊说明
        self.process_model(PrivateMessagePush, 'content')  # 私信推送.私信内容
        self.process_model(DoctorContent, 'content')  # 医生运营内容.内容
        self.process_model(Gadget, 'image_data')  # 固定模板
        self.process_model(Order, 'service_snapshot')  # 订单快照字段
        self.process_model(ServiceSnapshot, 'detail_description')  # 订单快照字段

        self.process_model(Tag, 'description')  # 标签.描述
