# coding=utf-8
from django.core.management import BaseCommand

from api.models import Service


class Command(BaseCommand):
    """
    python manage.py set_service_count_max
    """

    def handle(self, *args, **options):
        services = Service.objects.all()
        count = services.count()
        begin = 0
        step = 1000
        while begin <= count:
            for service in services[begin:begin + step]:
                try:
                    if service.sell_num_limit <= 0:
                        continue
                    service.sell_num_limit = 999999
                    service.total_num = 999999
                    service.save()
                    print service.id
                except Exception as e:
                    print str(service.id) + e.message
                    continue

            begin += step
