#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django.conf import settings
from django.core.management import BaseCommand

from api.models import SignUserExchangedPrize

invalid_user_ids = [32910336, 33368577, 33573378, 33562628, 33657860, 33545737, 33540109, 32996878, 33660942, 33285651, 32875541, 33223703, 31975960, 32755226, 32375836, 33696284, 31740959, 33537569, 32269858, 33431588, 31917094, 32767526, 32536106, 32155691, 33659948, 33680943, 33524279, 33362490, 33524795, 31460413, 33645629, 33523776, 32168001, 32881219, 32766020, 33533508, 33719880, 32445513, 33560137, 30001228, 32878157, 33563729, 33494098, 32713302, 32793690, 33714779, 33703006, 33129060, 33306724, 33047655, 31591537, 32353397, 22607992, 32885368, 33238137, 33702523, 33710717, 33504894, 32337536, 33399942, 33550983, 33399944, 33186441, 33705096, 32504977, 32760467, 33238676, 32267418, 33565340, 32862877, 33696924, 32267431, 32267432, 33730215, 33426607, 32397488, 33544367, 33206966, 33537719, 33524410, 33700538, 32644284, 32239293, 32862910, 31663807, 33050301, 1943745, 33459903, 31799491, 33545920, 33486533, 33698496, 29201611, 33703122, 33708242, 33523929, 33565401, 32930524, 33131229, 32997086, 33655006, 33668830, 33675996, 30829286, 32252646, 32726759, 33424616, 33539815, 31887083, 32525551, 33200368, 32873203, 33573621, 32927478, 33526519, 31848696, 31147259, 32523004, 33716990, 33523969, 32852738, 33338629, 33136902, 32797965, 32202512, 24145688, 33181979, 31913757, 32667422, 33661727, 32816416, 33763107, 32654628, 32734501, 32610089, 33697579, 28099885, 31960367, 32728367, 32506161, 33200945, 33315635, 33530163, 33534264, 32204090, 32870203, 33520443, 32900928, 33504065, 33049924, 33704261, 32793929, 31973711, 32720208, 33335631, 33470799, 33565011, 33657679, 33687893, 33702230, 32955223, 33029466, 33046876, 32403297, 33195874, 33690978, 33710950, 32072040, 32391529, 24084330, 33711978, 33470834, 33643378, 33621877, 33711989, 32807799, 32696184, 32641405, 33379711, 32764292, 32651142, 33489286, 33716104, 33727367, 33731978, 32043917, 33715085, 33714577, 32408978, 31174036, 31873941, 33214360, 33622427, 32377758, 33622430, 32093600, 33076642, 596900, 33538469, 33109414, 33529255, 33489834, 33551788, 33658797, 33712047, 31049136, 33680817, 33661365, 33400759, 32684472, 32703416, 32874937, 33524155, 33312191, 33528772, 33557445, 32928205, 33723341, 33405395, 33415123, 28711381, 33553366, 33546201, 33541594, 33720283, 30673373, 32680415, 32250848, 32928223, 32614370, 33405407, 33525729, 33644514, 32793574, 32957930, 33015788, 33395692, 31871985, 33405426, 33077241, 33345020]

log_path = '/tmp/'
prize_log = log_path + "sign_record_with_prizes.log"
raw_line = "{user_id}:{prize_id}:{created_time}:{express_no}\n"
record_line = []


class Command(BaseCommand):
    """
    python manage.py sign_log_reset_v3
    处理补签数据
    """

    def handle(self, *args, **options):

        for user_id in invalid_user_ids:
                # 记录无效补签的用户
                prize_record = SignUserExchangedPrize.objects.using(settings.HERA_READ_DB).filter(
                    user_id=user_id,
                ).last()
                record_line.append(raw_line.format(
                    user_id=user_id,
                    prize_id=prize_record and prize_record.prize_id or '未兑奖',
                    created_time=prize_record and prize_record.created_time or '未兑奖',
                    express_no=prize_record and prize_record.express_no or '未发货',
                ))

        with open(prize_log, 'a+') as f:
            f.writelines(record_line)

        print('Done')
