# -*- coding: utf-8 -*-

from django.core.management import BaseCommand
from gm_types.gaia import TAG_V3_TYPE
from django.conf import settings

from agile.models import TagV3, TagSynonym


class Command(BaseCommand):

    def handle(self, *args, **options):
        for _type, desc in TAG_V3_TYPE:
            tag_ids = list(TagV3.objects.using(settings.SLAVE_DB_NAME).filter(
                tag_type=_type
            ).values_list('id', flat=True))
            TagSynonym.objects.filter(tag_id__in=tag_ids).update(tag_type=_type)
        print("DONE")
