#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand

from gm_types.gaia import (
    TAG_TYPE,
)

from api.models import *
from agile.models.tag import TagMapOldTag


def get_all_v1_city_tags():

    objs = Tag.objects.filter(
        is_online=True,
        tag_type__in=[TAG_TYPE.CITY, TAG_TYPE.PROVINCE, TAG_TYPE.COUNTRY]
    )

    return {i.name: i.id for i in objs}


def get_all_v3_city_tags():
    objs = TagV3.objects.filter(
        tag_type__in=(TAG_V3_TYPE.CITY, TAG_V3_TYPE.PROVINCE, TAG_V3_TYPE.COUNTRY),
        is_online=True
    ).values('id', 'name')
    return {i['name']: i['id'] for i in objs}


def get_city_tag_v1tov3_mapping():
    t1 = get_all_v1_city_tags()
    t3 = get_all_v3_city_tags()
    result = {}
    for i in t1:
        if i in t3 and t1[i] not in result:
            result[t1[i]] = t3[i]
            print(u"%s 1.0: %s, 3.0: %s", i, t1[i], t3[i])
        else:
            print(u"%s %s, not found", i, t1[i])
    return result

city_tag_v1to_v3_map = get_city_tag_v1tov3_mapping()


class Command(BaseCommand):

    def handle(self, *args, **options):
        for i in city_tag_v1to_v3_map:
            TagMapOldTag.add_relation_by_id(i, city_tag_v1to_v3_map[i])
            print("[tagmapoldtag]1.0: %s, 3.0: %s", i, city_tag_v1to_v3_map[i])
