# -*- coding: utf-8 -*-


from django.core.management import BaseCommand
from rpc.tool.log_tool import info_logger
from api.models import Service, MerchantRelevance, Merchant
from gm_types.gaia import MERCHANT_LEVEL_NEW
from django.db import transaction
import json


class Command(BaseCommand):
    def handle(self, *args, **options):
        with transaction.atomic():

            # 查询出所有v2345等级的商户下医生列表
            v2_count = 395
            v3_count = 981
            v45_count = 4790
            # merchant_id:[doctor_id,,,]
            v2_merchant_doctor_map = {}
            v3_merchant_doctor_map = {}
            v45_merchant_doctor_map = {}

            # v2
            # 查询
            doctor_merchant_list_v2 = MerchantRelevance.objects.filter(merchant__merchant_level=MERCHANT_LEVEL_NEW.V2).\
                values_list('doctor_id', 'merchant_id')
            # 统计
            for doctor_id, merchant_id in doctor_merchant_list_v2:
                v2_merchant_doctor_map.setdefault(merchant_id, []).append(doctor_id)
            # 日志
            info_logger.info('update_fake_sold_num_v2345--------v2_merchant_doctor_map----{}'.format(
                json.dumps(v2_merchant_doctor_map)))
            # 修改
            for merchant_id in v2_merchant_doctor_map:
                doctor_id_list = v2_merchant_doctor_map[merchant_id]
                if doctor_id_list:
                    # 所有fake_sold_num 不为0的在线美购 service_id:fake_sold_num
                    service_fake_sold_num_map = {}
                    # 查询出所有的医生对应的美购
                    service_id_fake_list = Service.objects.filter(
                        doctor_id__in=doctor_id_list, is_online=True, doctor__is_online=True).values_list('id', 'fake_sold_num')
                    now_fake_sold_num_count = 0
                    for service_id, fake_sold_num in service_id_fake_list:
                        if fake_sold_num:
                            now_fake_sold_num_count += fake_sold_num
                            service_fake_sold_num_map[service_id] = fake_sold_num
                    if now_fake_sold_num_count>v2_count:
                        info_logger.info('update_fake_sold_num_v2345----v2_merchant-----{}---'
                                         '---fake_sold_num_count-----{}'.format(merchant_id, now_fake_sold_num_count))
                        for service_id in service_fake_sold_num_map:
                            now_fake_sold_num = service_fake_sold_num_map[service_id]
                            after_fake_sold_num = int(round(v2_count * (float(now_fake_sold_num)/now_fake_sold_num_count)))
                            if after_fake_sold_num != now_fake_sold_num:
                                Service.objects.filter(id=service_id).update(fake_sold_num=after_fake_sold_num)
                                info_logger.info('update_fake_sold_num_v2345-----v2_service--{}--'
                                                 '---old_fake_sold_num----{}------new_fake_sold_num----{}'.
                                                 format(service_id, now_fake_sold_num, after_fake_sold_num))

            # v3
            # 查询
            doctor_merchant_list_v3 = MerchantRelevance.objects.filter(merchant__merchant_level=MERCHANT_LEVEL_NEW.V3). \
                values_list('doctor_id', 'merchant_id')
            # 统计
            for doctor_id, merchant_id in doctor_merchant_list_v3:
                v3_merchant_doctor_map.setdefault(merchant_id,[]).append(doctor_id)
            # 日志
            info_logger.info('update_fake_sold_num_v2345--------v3_merchant_doctor_map----{}'.format(
                json.dumps(v3_merchant_doctor_map)))
            # 修改
            for merchant_id in v3_merchant_doctor_map:
                doctor_id_list = v3_merchant_doctor_map[merchant_id]
                if doctor_id_list:
                    # 所有fake_sold_num 不为0的在线美购 service_id:fake_sold_num
                    service_fake_sold_num_map = {}
                    # 查询出所有的医生对应的美购
                    service_id_fake_list = Service.objects.filter(doctor_id__in=doctor_id_list, is_online=True, doctor__is_online=True).values_list('id', 'fake_sold_num')
                    now_fake_sold_num_count = 0
                    for service_id, fake_sold_num in service_id_fake_list:
                        if fake_sold_num:
                            now_fake_sold_num_count += fake_sold_num
                            service_fake_sold_num_map[service_id] = fake_sold_num
                    if now_fake_sold_num_count>v3_count:
                        info_logger.info('update_fake_sold_num_v2345----v3_merchant-----{}---'
                                         '---fake_sold_num_count-----{}'.format(merchant_id, now_fake_sold_num_count))
                        for service_id in service_fake_sold_num_map:
                            now_fake_sold_num = service_fake_sold_num_map[service_id]
                            after_fake_sold_num = int(round(v3_count * (float(now_fake_sold_num)/now_fake_sold_num_count)))
                            if after_fake_sold_num != now_fake_sold_num:
                                Service.objects.filter(id=service_id).update(fake_sold_num=after_fake_sold_num)
                                info_logger.info('update_fake_sold_num_v2345-----v3_service--{}--'
                                                 '---old_fake_sold_num----{}------new_fake_sold_num----{}'.
                                                 format(service_id, now_fake_sold_num, after_fake_sold_num))

            # v45
            # 查询
            doctor_merchant_list_v45 = MerchantRelevance.objects.filter(
                merchant__merchant_level__in=[MERCHANT_LEVEL_NEW.V4, MERCHANT_LEVEL_NEW.V5]). \
                values_list('doctor_id', 'merchant_id')
            # 统计
            for doctor_id, merchant_id in doctor_merchant_list_v45:
                v45_merchant_doctor_map.setdefault(merchant_id, []).append(doctor_id)
            # 日志
            info_logger.info('update_fake_sold_num_v2345--------v45_merchant_doctor_map----{}'.format(json.dumps(v45_merchant_doctor_map)))
            # 修改
            for merchant_id in v45_merchant_doctor_map:
                doctor_id_list = v45_merchant_doctor_map[merchant_id]
                if doctor_id_list:
                    # 所有fake_sold_num 不为0的在线美购 service_id:fake_sold_num
                    service_fake_sold_num_map = {}
                    # 查询出所有的医生对应的美购
                    service_id_fake_list = Service.objects.filter(doctor_id__in=doctor_id_list, is_online=True, doctor__is_online=True).values_list('id', 'fake_sold_num')
                    now_fake_sold_num_count = 0
                    for service_id, fake_sold_num in service_id_fake_list:
                        if fake_sold_num:
                            now_fake_sold_num_count+=fake_sold_num
                            service_fake_sold_num_map[service_id] = fake_sold_num
                    if now_fake_sold_num_count>v45_count:
                        info_logger.info('update_fake_sold_num_v2345----v45_merchant-----{}---'
                                         '---fake_sold_num_count-----{}'.format(merchant_id, now_fake_sold_num_count))
                        for service_id in service_fake_sold_num_map:
                            now_fake_sold_num = service_fake_sold_num_map[service_id]
                            after_fake_sold_num = int(round(v45_count*(float(now_fake_sold_num)/now_fake_sold_num_count)))
                            if after_fake_sold_num != now_fake_sold_num:
                                Service.objects.filter(id=service_id).update(fake_sold_num=after_fake_sold_num)
                                info_logger.info('update_fake_sold_num_v2345-----v45_service--{}--'
                                                 '---old_fake_sold_num----{}------new_fake_sold_num----{}'.
                                                 format(service_id, now_fake_sold_num, after_fake_sold_num))

        print u'Done!!!!!!!!!!!!!!!!!!'
