#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand

from api.models import ServiceRegisterVideo
from hippo.models import HospitalVideo

from api.tasks.service_task import set_water_mark_to_video_service
from api.tasks.hospital_task import set_water_mark_to_video_hospital


def update_service_video_water_mark_url():
    print("update service video water mark begin")
    service_video_ids = ServiceRegisterVideo.objects.values_list("id", flat=True)
    for service_video_id in service_video_ids.iterator():
        set_water_mark_to_video_service.delay(service_video_id)
    print("update service video water mark end")


def update_hospital_video_water_mark_url():
    print("update hospital video water mark begin")
    hospital_video_ids = HospitalVideo.objects.values_list("id", flat=True)
    for hospital_video_id in hospital_video_ids.iterator():
        set_water_mark_to_video_hospital.delay(hospital_video_id)
    print("update hospital video water mark end")


class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        print("BEGIN")
        update_service_video_water_mark_url()
        update_hospital_video_water_mark_url()
        print("END")
