# -*- coding: utf-8 -*-


from django.core.management import BaseCommand
from rpc.tool.log_tool import info_logger
from api.models import Service, MerchantRelevance, Merchant
from gm_types.gaia import MERCHANT_LEVEL_NEW


class Command(BaseCommand):
    def handle(self, *args, **options):
        # 查询出所有v0等级的商户下医生列表
        doctor_id_list = MerchantRelevance.objects.filter(merchant__merchant_level__in=[MERCHANT_LEVEL_NEW.V0,MERCHANT_LEVEL_NEW.V1]).\
            values_list('doctor_id', flat=True)

        info_logger.info('update_v1_fake_sole_num--------doctor_id_list----{}'.format(str(doctor_id_list)))
        # 查询出所有的属于v0商户医生的美购ID 和 fake_sold_num做记录
        if doctor_id_list:

            service_list = Service.objects.filter(doctor_id__in=doctor_id_list).values_list('id','fake_sold_num')
            for service_id, fake_sold_num in service_list:
                info_logger.info('update_v1_fake_sole_num------update----service---{}-----'
                                 '-fake_sole_num-----{}'.format(str(service_id), str(fake_sold_num)))
            Service.objects.filter(doctor_id__in=doctor_id_list).update(fake_sold_num=0)

        print u'Done!!!!!!!!!!!!!!!!!!'
