# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function

from gm_types.gaia import AppConfigValueType
from django.db import models


class AppConfig(models.Model):
	class Meta:
		verbose_name = u'应用通用配置'
		db_table = 'api_app_config'
		app_label = 'api'

	name = models.CharField(max_length=64, verbose_name="配置名称", db_index=True)
	key = models.CharField(max_length=128, verbose_name="配置关键字", unique=True)
	value = models.TextField(verbose_name="配置内容")
	value_type = models.CharField(max_length=32, verbose_name="配置内容 类型", choices=AppConfigValueType)

	is_online = models.BooleanField(verbose_name="是否上线", db_index=True)
	online_time = models.DateTimeField(verbose_name="上线时间", db_index=True)
	offline_time = models.DateTimeField(verbose_name="下线时间", db_index=True)
	create_time = models.DateTimeField(verbose_name="创建时间", auto_now_add=True)
	update_time = models.DateTimeField(verbose_name="更新时间", auto_now=True)
