# coding=utf-8

from django.db import models


class BlockRecord(models.Model):
    class Meta:
        verbose_name = u'user seal record table'
        app_label = 'api'
        db_table = 'api_user_seal_log'

    user_id = models.BigIntegerField(null=True)
    user_name = models.CharField(max_length=32, null=True, default="")
    user_phone = models.CharField(max_length=16, null=True, default="")
    item = models.PositiveSmallIntegerField(null=True)
    seal_time_type = models.PositiveSmallIntegerField(null=True)
    seal_time_start = models.DateTimeField(null=True)
    seal_time_end = models.DateTimeField(null=True)
    seal_duration = models.PositiveIntegerField(null=True)
    seal_type = models.PositiveSmallIntegerField(null=True)
    seal_reason = models.TextField(null=True)
    seal_status = models.PositiveSmallIntegerField(null=True)
    cancel_seal_reason = models.CharField(max_length=128, null=True, default="")
    cancel_seal_type = models.PositiveSmallIntegerField(null=True, default=0)
    cancel_seal_time = models.DateTimeField(null=True)
