# coding=utf8
from django.db import models
from api.models import BaseModel
from gm_types.gaia import CommodityCategoryProperty


class CommodityCategory(BaseModel):

    class Meta:
        verbose_name = u'商品类目信息'
        db_table = 'commodity_category'
        app_label = 'api'

    name = models.CharField(verbose_name=u'品类name', max_length=128)
    property_info = models.TextField(default=u'', verbose_name=u'类目信息')
    father_id = models.IntegerField(verbose_name=u'父级品类id', default=0)


class CommodityCategoryRelation(BaseModel):

    class Meta:
        verbose_name = u'商品类目关联关系'
        db_table = 'commodity_category_relation'
        app_label = 'api'

    commodity_id = models.IntegerField(verbose_name=u'商品id', default=0)
    commodity_register_id = models.IntegerField(verbose_name=u'商品注册id')
    category_id = models.IntegerField(verbose_name=u'类目id')

    def category_info(self):
        res = []
        obj = CommodityCategory.objects.filter(id=self.category_id).first()
        if not obj:
            return res

        res.append({"id": obj.id, "name":obj.name})
        while obj.father_id:
            obj = CommodityCategory.objects.filter(id=obj.father_id).first()
            if obj:
                res.append({"id": obj.id, "name": obj.name})

        res.reverse()
        return res


class CommodityCategoryPropertyRelation(BaseModel):

    class Meta:
        verbose_name = u'商品属性关联关系'
        db_table = 'commodity_category_property_relation'
        app_label = 'api'

    commodity_id = models.IntegerField(verbose_name=u'商品id', default=0)
    commodity_register_id = models.IntegerField(verbose_name=u'商品注册id')
    property_name = models.CharField(verbose_name=u'属性name', max_length=128)
    property_type = models.IntegerField(verbose_name=u'属性type', choices=CommodityCategoryProperty,
                                        default=CommodityCategoryProperty.POSITON)
