# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

import redis


class RedisClient(object):
    prefix = ""
    pool = None

    def __init__(self):
        self.client = redis.Redis(connection_pool=self.pool)

    def _get_key(self, key):
        return self.prefix + ":" + str(key)

    def increase(self, key):
        key = self._get_key(key)
        self.client.incr(key)

    def incrby(self, key, number):
        key = self._get_key(key)
        self.client.incrby(key, number)

    def get(self, key):
        key = self._get_key(key)
        return self.client.get(key)

