# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

import copy
import json
import datetime
import math
from django.conf import settings
from django.db import transaction
from django.db import models, IntegrityError
from django.contrib.auth.models import User
from gm_types.gaia import DISTRIBUTE_TYPES


class DistributeRecord(models.Model):
    class Meta:
        verbose_name_plural = u'分销师订单记录表'
        db_table = 'api_distribute_record'
        app_label = 'api'

    id = models.IntegerField(primary_key=True)

    order_id = models.CharField(verbose_name=u'订单id', db_index=True, max_length=128)
    distribute_id = models.CharField(verbose_name=u'分销师id', db_index=True, max_length=128) # 目前是返回的用户ID后期可以通过类型支持不同的id
    distribute_type = models.IntegerField(choices=DISTRIBUTE_TYPES, verbose_name=u'分销师ID类型')
    create_time = models.DateTimeField(
        verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name=u"更新时间", auto_now=True, db_column="update_time"
    )
