# coding: utf-8
from __future__ import absolute_import, print_function, unicode_literals

from django.db import models
from api.models.doctor import Doctor
from api.models.person import Person


class DoctorGroup(models.Model):

    class Meta:
        verbose_name = u'医生小组'
        app_label = 'api'
        db_table = 'api_doctorgroup'

    name = models.CharField(verbose_name=u'小组名称', max_length=64)

    def doctors(self):
        doctorrelations = DoctorRelatedDoctorgroup.objects.filter(doctorgroup=self, doctor__self_run=True).select_related('doctor')
        doctors = [doctorrelation.doctor for doctorrelation in doctorrelations]
        return doctors

    def users(self):
        userrelations = UserRelatedDoctorgroup.objects.filter(doctorgroup=self).select_related('person')
        users = [userrelation.person for userrelation in userrelations]
        return users


class DoctorRelatedDoctorgroup(models.Model):
    class Meta:
        verbose_name = u'医生与医生小组关系'
        app_label = 'api'
        db_table = 'api_doctor_related_doctorgroup'

    doctor = models.ForeignKey(Doctor, default=None, null=True, blank=True, related_name='doctor')
    doctorgroup = models.ForeignKey(DoctorGroup, default=None, null=True, blank=True)


class UserRelatedDoctorgroup(models.Model):
    class Meta:
        verbose_name = u'运营与医生小组关系'
        app_label = 'api'
        db_table = 'api_user_related_doctorgroup'

    person = models.ForeignKey(Person, default=None, null=True, blank=True, related_name='person')
    doctorgroup = models.ForeignKey(DoctorGroup, default=None, null=True, blank=True)
