# coding=utf-
from __future__ import unicode_literals, absolute_import, print_function
from django.db import models
from gm_types.gaia import (
    DOCTOR_PROCESS_STATUS, DOCTOR_TYPE)

from utils.uuid4 import uuid4


class Doctors(models.Model):
    class Meta:
        verbose_name = u'医生'
        db_table = 'api_doctor'

    id = models.CharField(max_length=100, primary_key=True, default=uuid4)
    name = models.CharField(max_length=200, verbose_name=u"姓名", db_index=True)
    doctor_type = models.CharField(max_length=1, default=DOCTOR_TYPE.DOCTOR,
                                   choices=DOCTOR_TYPE, null=False,
                                   verbose_name=u'医生类型')
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


#
class Hospitals(models.Model):
    class Meta:
        verbose_name = u'医院'
        db_table = 'api_hospital'

    id = models.CharField(verbose_name=u'医院ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"医院名称", max_length=100)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


#
class Areas(models.Model):
    class Meta:
        verbose_name = u'地区'
        db_table = 'api_city'

    id = models.CharField(verbose_name=u'地区ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"地区名称", max_length=20)


# != 'china'

class Countrys(models.Model):
    class Meta:
        verbose_name = u'国家'
        db_table = 'api_country'

    id = models.CharField(verbose_name=u'国家ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"医院名称", max_length=40)


#
class Users(models.Model):
    class Meta:
        verbose_name = u'用户'
        db_table = 'auth_user'

    id = models.IntegerField(verbose_name=u'用户ID', max_length=11, primary_key=True)
    last_name = models.CharField(verbose_name=u"用户名字", max_length=30)


class Projects(models.Model):
    class Meta:
        verbose_name = u'标签'
        db_table = 'api_tag'

    id = models.IntegerField(verbose_name=u'标签ID', max_length=11, primary_key=True)
    tag_type = models.CharField(verbose_name=u'类型', max_length=4)
    name = models.CharField(verbose_name=u"用户名字", max_length=64)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


# tag_type 123


class Products(models.Model):
    class Meta:
        verbose_name = u'产品百科'
        db_table = 'wiki_product'

    id = models.IntegerField(verbose_name=u'百科ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"产品名称", max_length=50)
    product_type = models.CharField(verbose_name="产品类型", max_length=4)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


class Items(models.Model):
    class Meta:
        verbose_name = u'项目百科'
        db_table = 'wiki_item'

    id = models.IntegerField(verbose_name=u'百科ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"百科项目名称", max_length=50)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


class Collect(models.Model):
    class Meta:
        verbose_name = u'聚合百科'
        db_table = 'wiki_collect'

    id = models.IntegerField(verbose_name=u'用户ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"百科聚合名称", max_length=50)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


class Brands(models.Model):
    class Meta:
        verbose_name = u'品牌百科'
        db_table = 'wiki_brand'

    id = models.IntegerField(verbose_name=u'百科ID', max_length=11, primary_key=True)
    name = models.CharField(verbose_name=u"百科名称", max_length=48)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)
