# -*- coding: utf-8 -*-
import json
from django.db import models
from gm_types.gaia import SCAN_TYPE


class AiTarget(models.Model):

    class Meta:
        verbose_name = u'AI指标'
        db_table = 'api_ai_target'

    part = models.CharField(max_length=30, verbose_name="部位", null=False)
    part_type = models.CharField(max_length=1, verbose_name='部位类型', choices=SCAN_TYPE, default=SCAN_TYPE.SCAN_FACE)
    target_desc = models.TextField(verbose_name="指标说明", null=False)
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
