# coding: utf-8

"""
风格脸相关黄金值比例的数据存储TABLE
"""


from django.db import models

from gm_types.face import (
	GoldValueDefineType,
	GoldSkinValue,
	PointLocationType,
	IncludedAngleType,
	PointValueUnit,
	RatioCombination,
	CheekStyleSort,
)


class CheekStyle(models.Model):
	class Meta:
		verbose_name = u'风格脸'
		db_table = 'cheek_style'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	name = models.CharField(verbose_name=u"风格脸名称", max_length=64, null=False, default="")
	image_url = models.CharField(verbose_name=u"风格脸模板图片", max_length=512, null=False, default="")
	is_online = models.IntegerField(verbose_name=u"是否上线", null=False, default=0)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class PointLocation(models.Model):
	class Meta:
		verbose_name = u'点位信息'
		db_table = 'point_location'
		app_label = 'plastic'
	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	gold_percent_define_id = models.IntegerField(verbose_name=u"黄金比例值定义id")
	name = models.CharField(verbose_name=u"绝对值名称", max_length=64, null=False, default="")
	point_one = models.IntegerField(verbose_name=u"点位1")
	point_one_type = models.IntegerField(
		verbose_name=u"点1点位类型", choices=PointLocationType, default=PointLocationType.X_Y)

	point_two = models.IntegerField(verbose_name=u"点位2")
	point_two_type = models.IntegerField(
		verbose_name=u"点2点位类型", choices=PointLocationType, default=PointLocationType.X_Y)

	point_three = models.IntegerField(verbose_name=u"点位3")
	point_three_type = models.IntegerField(
		verbose_name=u"点3点位类型", choices=PointLocationType, default=PointLocationType.X_Y)
	point_max_diff_value = models.FloatField(verbose_name=u"最大差值(正值)", default=0)
	point_diff_value_negative = models.FloatField(verbose_name=u"最大差值(负值)", default=0)
	included_angle_type = models.IntegerField(
		verbose_name=u"夹角类型", choices=IncludedAngleType, default=IncludedAngleType.LESS_THAN_90)
	is_special = models.IntegerField(verbose_name=u"是否是特殊规则", default=0)
	is_denominator = models.IntegerField(verbose_name=u"是否为分母", default=0)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class GoldSkinInfo(models.Model):
	class Meta:
		verbose_name = u'美学肤质'
		db_table = 'gold_skin_info'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	gold_percent_define_id = models.IntegerField(verbose_name=u"黄金比例值定义id")
	skin_type = models.IntegerField(verbose_name=u"肤质类型", choices=GoldSkinValue, default=GoldSkinValue.skin_color)
	skin_type_max_diff_value = models.FloatField(verbose_name=u"肤质最大差值(正值)", null=False, default=0)
	skin_type_value_negative = models.FloatField(verbose_name=u"肤质最大差值(负值)", default=0)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class GoldPercentDefine(models.Model):
	class Meta:
		verbose_name = u'美学比值例定义'
		db_table = 'gold_percent_define'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	key = models.CharField(verbose_name=u"美学值关键字", max_length=64)
	name = models.CharField(verbose_name=u"比例名称", max_length=64, null=False, default="")
	define_type = models.IntegerField(
		verbose_name=u"定义类型", choices=GoldValueDefineType, default=GoldValueDefineType.PERCENT)
	is_online = models.IntegerField(verbose_name=u"是否上线", null=False, default=0)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class CheekStyleSample(models.Model):
	class Meta:
		verbose_name = u'风格脸样本库'
		db_table = 'cheek_style_sample'
		app_label = 'plastic'
	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_id = models.IntegerField(verbose_name=u"风格脸id")
	image_url = models.CharField(verbose_name=u"风格脸模板图片", max_length=512, null=False, default="")
	is_sample = models.IntegerField(verbose_name=u"是否为样本", null=False, default=1)
	discern_status = models.IntegerField(verbose_name=u"样本是否调用 人脸识别接口")
	deleted = models.IntegerField(verbose_name=u"是否被删除", null=False, default=0)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class FaceGoldValue(models.Model):
	class Meta:
		verbose_name = u'风格脸黄金比例值'
		db_table = 'face_gold_value'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_sample_id = models.IntegerField(verbose_name=u"风格脸样本库")
	gold_percent_define_id = models.IntegerField(verbose_name=u"黄金比例值定义id")
	percent_value = models.FloatField(verbose_name=u"比例值")
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class FeatureWeightValue(models.Model):
	class Meta:
		verbose_name = u'二级诉求标签特征幅度区间'
		db_table = 'feature_scope_section'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	secondary_demand_id = models.IntegerField(verbose_name=u"二级诉求id")
	secondary_demand_name = models.CharField(verbose_name=u"二级诉求名称", max_length=64)
	unit = models.IntegerField(
		verbose_name=u"单位", choices=PointValueUnit, default=PointValueUnit.CENTIMETRE)
	tag_ids = models.TextField(verbose_name=u"项目标签ids（tag_v3）")
	x_value = models.FloatField(verbose_name=u"x的值")
	y_value = models.FloatField(verbose_name=u"y的值")
	weight = models.FloatField(verbose_name=u"权重")
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class UserPlasticHistory(models.Model):

	class Meta:
		verbose_name = u'用户模拟整形历史'
		db_table = 'user_plastic_history'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	url_key = models.CharField(verbose_name=u"url 关键字", max_length=32)
	image_url = models.CharField(verbose_name=u"图片地址", max_length=512)
	megvii_landmark = models.TextField(verbose_name=u"旷视landmark")
	byte_dance_landmark = models.TextField(verbose_name=u"字节landmark")
	gold_values = models.TextField(verbose_name=u"计算出来的所有的美学值")
	device_id = models.CharField(max_length=100, verbose_name=u'设备ID', db_index=True, default="")
	user_id = models.BigIntegerField(verbose_name=u'用户ID', db_index=True, default=0)
	proportion = models.CharField(
		verbose_name=u"关键比值", max_length=16,
		choices=RatioCombination, default=RatioCombination.COMBINATION_A)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class CheekStyleClassify(models.Model):
	class Meta:
		verbose_name = u'风格脸类别'
		db_table = 'cheek_style_classify'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	name = models.CharField(verbose_name=u"类别名称", max_length=64, null=False, default="")
	rank = models.IntegerField(verbose_name=u"rank", db_index=True)
	is_online = models.BooleanField(verbose_name=u"是否上线", null=False, default=0)
	deleted = models.BooleanField(verbose_name=u"是否被删除", null=False, default=1)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class CheekStyleClassifyMap(models.Model):
	class Meta:
		verbose_name = u'风格脸类别映射表'
		db_table = 'cheek_style_classify_map'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_classify_id = models.IntegerField(verbose_name=u"风格脸类别主键", default=0)
	cheek_style_id = models.IntegerField(verbose_name=u"风格脸主键", default=0)
	sort_type = models.IntegerField(
		verbose_name=u"排序类型", choices=CheekStyleSort, default=CheekStyleSort.FEASIBILITY)
	is_online = models.BooleanField(verbose_name=u"是否上线", null=False, default=0)
	deleted = models.BooleanField(verbose_name=u"是否被删除", null=False, default=1)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class UserCheekTypesFeasibility(models.Model):

	class Meta:
		verbose_name = u'用户风格脸可行性值'
		db_table = 'user_cheek_types_feasibility'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_id = models.IntegerField(verbose_name=u"风格脸id")
	user_plastic_history_id = models.IntegerField(verbose_name=u"用户模拟整形历史id")
	feasibility_info = models.TextField(verbose_name=u"风格脸可行性值，计算出来的json")
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class CheekStyleExtra(models.Model):
	class Meta:
		verbose_name = u'风格脸exra表'
		db_table = 'cheek_style_extra'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_id = models.IntegerField(verbose_name=u"风格脸主键", default=0, db_index=True)
	desc = models.CharField(verbose_name=u"描述文案", max_length=64, null=False, default="")
	analyze = models.CharField(verbose_name=u"分析文案", max_length=64, null=False, default="")
	is_online = models.BooleanField(verbose_name=u"是否上线", null=False, default=0)
	deleted = models.BooleanField(verbose_name=u"是否被删除", null=False, default=1)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)


class CheekStyleAppealExtra(models.Model):
	class Meta:
		verbose_name = u'风格脸诉求exra表'
		db_table = 'cheek_style_appeal_extra'
		app_label = 'plastic'

	id = models.AutoField(verbose_name=u"主键", primary_key=True)
	cheek_style_id = models.IntegerField(verbose_name=u"风格脸主键", default=0)
	appeal_tag_name = models.CharField(verbose_name=u"诉求标签名称", max_length=32, null=False, default="")
	desc = models.CharField(verbose_name=u"诉求文案", max_length=64, null=False, default="")
	is_online = models.BooleanField(verbose_name=u"是否上线", null=False, default=0)
	deleted = models.BooleanField(verbose_name=u"是否被删除", null=False, default=1)
	create_time = models.DateTimeField(
		verbose_name=u"创建时间", auto_now_add=True, db_column="create_time"
	)
	update_time = models.DateTimeField(
		verbose_name=u"更新时间", auto_now=True, db_column="update_time"
	)
