# -*- coding: utf-8 -*-

from django.db import models

from gm_types.gaia import (
    FACIAL_FEATUREA,
    CONTOUR_TYPE,
    CHIN_TYPE,
    EYEBROW_TYPE,
    EYE_TYPE,
    NOSE_TYPE,
    LIP_TYPE,
    USER_GENDER
)


class Facial(models.Model):
    class Meta:
        verbose_name = u'五官表'
        db_table = 'api_facial'

    facial_type = models.SmallIntegerField(verbose_name=u'部位', choices=FACIAL_FEATUREA, default=FACIAL_FEATUREA.CONTOUR)
    classification = models.CharField(max_length=30, verbose_name="部位具体类型", null=False)
    desc = models.CharField(max_length=1024, verbose_name="文案描述")
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class FacialCombi(models.Model):
    class Meta:
        verbose_name = u'五官组合表'
        db_table = 'api_facial_combination'

    contour = models.CharField(max_length=30, verbose_name="脸型", choices=CONTOUR_TYPE, default=CONTOUR_TYPE.UNKNOW)
    chin = models.CharField(max_length=30, verbose_name="下巴", choices=CHIN_TYPE, default=CHIN_TYPE.UNKNOW)
    eyebrow = models.CharField(max_length=30, verbose_name="眉毛", choices=EYEBROW_TYPE, default=EYEBROW_TYPE.UNKNOW)
    eye = models.CharField(max_length=30, verbose_name="眼睛", choices=EYE_TYPE, default=EYE_TYPE.UNKNOW)
    nose = models.CharField(max_length=30, verbose_name="鼻", choices=NOSE_TYPE, default=NOSE_TYPE.UNKNOW)
    lip = models.CharField(max_length=30, verbose_name="唇", choices=LIP_TYPE, default=LIP_TYPE.UNKNOW)

    title = models.CharField(max_length=50, verbose_name="标题")
    desc = models.CharField(max_length=1024, verbose_name="文案描述", default='')

    celebrity = models.CharField(max_length=32, verbose_name="明星")
    gender = models.CharField(max_length=1, verbose_name='性别', choices=USER_GENDER, default=USER_GENDER.FEMALE)
    image_url = models.CharField(max_length=80, verbose_name='脸型对应的漫画图片')
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class FacialFeatureFamily(models.Model):
    class Meta:
        verbose_name = "五官分类相关信息"
        db_table = 'api_facial_feature_family'

    classification = models.CharField(verbose_name=u"部位具体类型", max_length=64)
    facial_type = models.CharField(verbose_name=u"部位", max_length=3, choices=FACIAL_FEATUREA,
                                   default=FACIAL_FEATUREA.CONTOUR)
    client = models.BooleanField(null=False, default=True, verbose_name='客户端展示')
    xcx = models.BooleanField(null=False, default=True, verbose_name='小程序展示')
    desc1 = models.CharField(verbose_name=u"文案描述1", max_length=256)
    desc2 = models.CharField(verbose_name=u"症状展示", max_length=256)
    img_url = models.CharField(verbose_name=u"图片地址", max_length=128)
    polymer_id = models.CharField(verbose_name=u"聚合页id", max_length=32)
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
    choice_button_words = models.CharField(verbose_name=u"社区按钮文字", max_length=64)
    service_button_words = models.CharField(verbose_name=u"文美购按钮文字", max_length=64)
    topic_id = models.IntegerField(verbose_name=u"话题id")
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
