#! /usr/bin/env python
# -*- coding: utf-8 -*-

from gm_types.gaia import (
    CONTOUR_TYPE,
    CHIN_TYPE,
    EYEBROW_TYPE,
    EYE_TYPE,
    NOSE_TYPE,
    LIP_TYPE,
    USER_GENDER
)
from django.db import models


class NanshenQuestion(models.Model):
    class Meta:
        verbose_name = u'测试题配置'
        db_table = 'api_nanshen_question'

    vector = models.CharField(verbose_name=u"维度", max_length=32, default='')
    question = models.CharField(verbose_name=u"问题", max_length=512, default='')
    choice1 = models.CharField(verbose_name=u"选项1", max_length=512, default='')
    type1 = models.CharField(verbose_name=u"类型1", max_length=512, default='')
    choice2 = models.CharField(verbose_name=u"选项2", max_length=512, default='')
    type2 = models.CharField(verbose_name=u"类型2", max_length=512, default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class NanshenAnswer(models.Model):
    class Meta:
        verbose_name = u'男神答案配置'
        db_table = 'api_nanshen_answer'

    vector1 = models.CharField(verbose_name=u"维度1", max_length=32, default='')
    vector2 = models.CharField(verbose_name=u"维度2", max_length=32, default='')
    vector3 = models.CharField(verbose_name=u"维度3", max_length=32, default='')
    vector4 = models.CharField(verbose_name=u"维度4", max_length=32, default='')
    celebrity = models.CharField(max_length=32, verbose_name="明星")
    celebrity_image = models.CharField(max_length=128, verbose_name='明星图片')
    nanshen = models.CharField(max_length=32, verbose_name="男神")
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class NanshenReport(models.Model):
    class Meta:
        verbose_name = u'男神报告配置'
        db_table = 'api_nanshen_report'

    vector = models.CharField(verbose_name=u"维度", max_length=32, default='')
    vector_name = models.CharField(verbose_name=u"维度名称", max_length=32, default='')
    vector_type = models.CharField(verbose_name=u"类型", max_length=32, default='')
    content1 = models.CharField(verbose_name=u"文案1", max_length=2048, default='')
    content2 = models.CharField(verbose_name=u"文案2", max_length=2048, default='')
    keyword = models.CharField(verbose_name=u"关键词", max_length=128, default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class NanshenFaceType(models.Model):
    class Meta:
        verbose_name = u'收割机脸部'
        db_table = 'api_nanshen_face_type'

    contour = models.CharField(max_length=30, verbose_name="脸型", choices=CONTOUR_TYPE, default=CONTOUR_TYPE.UNKNOW)
    chin = models.CharField(max_length=30, verbose_name="下巴", choices=CHIN_TYPE, default=CHIN_TYPE.UNKNOW)
    eyebrow = models.CharField(max_length=30, verbose_name="眉毛", choices=EYEBROW_TYPE, default=EYEBROW_TYPE.UNKNOW)
    eye = models.CharField(max_length=30, verbose_name="眼睛", choices=EYE_TYPE, default=EYE_TYPE.UNKNOW)
    nose = models.CharField(max_length=30, verbose_name="鼻", choices=NOSE_TYPE, default=NOSE_TYPE.UNKNOW)
    lip = models.CharField(max_length=30, verbose_name="唇", choices=LIP_TYPE, default=LIP_TYPE.UNKNOW)
    face_type = models.CharField(max_length=50, verbose_name="面部类型")
    content = models.CharField(max_length=2048, verbose_name="文案描述")
    gender = models.CharField(max_length=1, verbose_name='性别', choices=USER_GENDER, default=USER_GENDER.FEMALE)
    celebrity = models.CharField(max_length=32, verbose_name="明星")
    celebrity_image = models.CharField(max_length=80, verbose_name='明星图片')
    nanshen = models.CharField(max_length=32, verbose_name="收割男神")
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class ShareRecord(models.Model):
    class Meta:
        verbose_name = u'分享记录'
        db_table = 'api_nanshen_share_record'

    user_id = models.IntegerField(verbose_name=u"分享用户id", null=False, db_index=True)
    user_name = models.CharField(verbose_name=u"用户昵称", max_length=64, default='')
    user_icon = models.CharField(verbose_name=u"用户头像", max_length=64, default='')
    content = models.CharField(verbose_name=u"分享内容", max_length=1024, default='')
    unlock_content = models.CharField(verbose_name=u"解锁可查看", max_length=4096, default='')
    form_id = models.CharField(verbose_name=u"小程序form_id", max_length=64, default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class UnlockRecord(models.Model):
    class Meta:
        verbose_name = u'助力解锁记录'
        db_table = 'api_nanshen_unlock_record'

    user_id = models.IntegerField(verbose_name=u"助力用户ID", null=False, db_index=True)
    user_name = models.CharField(verbose_name=u"用户昵称", max_length=64, default='')
    user_icon = models.CharField(verbose_name=u"用户头像", max_length=256, default='')
    unlock = models.ForeignKey(ShareRecord, verbose_name="助力解锁的ID")
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
