# -*- coding: utf-8 -*-
from django.db import models
from gm_types.gaia import (
    SKIN_CONF_ACNE_TYPE,
    SKIN_CONF_CHEEK_TYPE,
    SKIN_CONF_CHIN_TYPE,
    SKIN_CONF_COLOR_TEMP_TYPE,
    SKIN_CONF_HEITOU_TYPE,
    SKIN_CONF_MAOKONG_TYPE,
    SKIN_CONF_PIGMENTAL_TYPE,
    SKIN_CONF_SMOOTH_TYPE,
    SKIN_CONF_STRUCT_TYPE,
    SKIN_CONF_T_ZONE_TYPE,
    SKIN_CONF_VASCULAR_TYPE,
    SKIN_CONF_ACT_WRINKLE_TYPE,
    SKIN_CONF_EYE_BAG_TYPE,
    KS_SKIN_ALL_TYPE,
    KS_DARK_CIRCLE_TYPE,
    KS_SKIN_TYPE,
    KS_BLACKHEAD_TYPE,
    KS_PORES_FOREHEAD_TYPE,
    KS_PORES_LEFT_CHEEK_TYPE,
    KS_PORES_RIGHT_CHEEK_TYPE,
    KS_PORES_JAW_TYPE,
    KS_PORE_TYPE,
    KS_ACNE_TYPE,
    KS_EYE_POUCH_TYPE,
    KS_NASOLABIAL_FOLD_TYPE,
    KS_SKIN_COLOR,
    KS_SKIN_SPOT_TYPE,
    KS_MOLE_TYPE,
    KS_FOREHEAD_WRINKLE_YPE,
    KS_GLABELLA_WRINKLE_YPE,
    KS_CROWS_FEET_YPE,
    KS_EYE_FINELINES_YPE,
    AI_VIDEO_CHANNEL,
)
from gm_upload import IMG_TYPE, ImgUrlField


class SkinAge(models.Model):
    class Meta:
        verbose_name = u'肤龄相关信息'
        db_table = 'api_skin_age'

    content = models.CharField(max_length=32, verbose_name="风格类型")
    max_age = models.IntegerField(verbose_name=u'上限年龄', default=0)
    min_age = models.IntegerField(verbose_name=u"下限年龄", default=0)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID", default=0)
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class SkinOil(models.Model):
    class Meta:
        verbose_name = u'皮肤油脂分类相关信息'
        db_table = 'api_skin_oil_type'

    t_zone = models.IntegerField(verbose_name="t区", choices=SKIN_CONF_T_ZONE_TYPE,
                                 default=SKIN_CONF_T_ZONE_TYPE.LEVLE_1)
    chin = models.IntegerField(verbose_name="下巴", choices=SKIN_CONF_CHIN_TYPE, default=SKIN_CONF_CHIN_TYPE.LEVLE_1)
    cheek = models.IntegerField(verbose_name="脸颊", choices=SKIN_CONF_CHEEK_TYPE, default=SKIN_CONF_CHEEK_TYPE.LEVLE_1)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Heitou(models.Model):
    class Meta:
        verbose_name = u'黑头毛孔分类相关信息'
        db_table = 'api_heitou_type'

    heitou_level = models.IntegerField(verbose_name="黑头程度", choices=SKIN_CONF_HEITOU_TYPE,
                                       default=SKIN_CONF_HEITOU_TYPE.NONE)
    maokong_level = models.IntegerField(verbose_name="毛孔程度", choices=SKIN_CONF_MAOKONG_TYPE,
                                        default=SKIN_CONF_MAOKONG_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Acne(models.Model):
    class Meta:
        verbose_name = u'痘痘分类相关信息'
        db_table = 'api_acne_type'

    level = models.IntegerField(verbose_name="痘痘严重程度", choices=SKIN_CONF_ACNE_TYPE, default=SKIN_CONF_ACNE_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Smoothlevel(models.Model):
    class Meta:
        verbose_name = u'光滑度分类相关信息'
        db_table = 'api_smooth_level'

    level = models.IntegerField(verbose_name="光滑度", choices=SKIN_CONF_SMOOTH_TYPE,
                                default=SKIN_CONF_SMOOTH_TYPE.LEVLE_1)
    level_image = models.CharField(verbose_name=u"光滑度照片", max_length=256, default='')
    image_desc = models.CharField(verbose_name=u"照片描述", max_length=256, default='')
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class HeiYanQuan(models.Model):
    class Meta:
        verbose_name = u'黑眼圈分类相关信息'
        db_table = 'api_heiyanquan_type'

    pigmental = models.IntegerField(verbose_name="色素", choices=SKIN_CONF_PIGMENTAL_TYPE,
                                    default=SKIN_CONF_PIGMENTAL_TYPE.LEVLE_1)
    vascular = models.IntegerField(verbose_name="血管", choices=SKIN_CONF_VASCULAR_TYPE,
                                   default=SKIN_CONF_VASCULAR_TYPE.LEVLE_1)
    struct = models.IntegerField(verbose_name="结构", choices=SKIN_CONF_STRUCT_TYPE,
                                 default=SKIN_CONF_STRUCT_TYPE.LEVLE_1)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class SkinColor(models.Model):
    class Meta:
        verbose_name = u'肤色分类相关信息'
        db_table = 'api_skin_color_type'

    color_level = models.IntegerField(verbose_name="色号", null=False)
    color_image = models.CharField(verbose_name=u"色号图片", max_length=256, default='')
    color_desc = models.CharField(verbose_name=u"色号描述", max_length=256, default='')
    color_temperature = models.IntegerField(verbose_name="肤色色温", choices=SKIN_CONF_COLOR_TEMP_TYPE,
                                            default=SKIN_CONF_COLOR_TEMP_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class ActWrinkle(models.Model):
    class Meta:
        verbose_name = u'法令纹'
        db_table = 'api_skin_act_wrinkle'

    state = models.IntegerField(verbose_name="状态", choices=SKIN_CONF_ACT_WRINKLE_TYPE,
                                default=SKIN_CONF_ACT_WRINKLE_TYPE.NONE)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class EyeBag(models.Model):
    class Meta:
        verbose_name = u'眼袋'
        db_table = 'api_skin_eye_bag'

    state = models.IntegerField(verbose_name="状态", choices=SKIN_CONF_EYE_BAG_TYPE,
                                default=SKIN_CONF_EYE_BAG_TYPE.NONE)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class SkinType(models.Model):
    class Meta:
        verbose_name = u'旷视测肤结果相关信息'
        db_table = 'api_skin_type'

    type_content = models.IntegerField(verbose_name="测肤类型(部位)", choices=KS_SKIN_ALL_TYPE,
                                        default=KS_SKIN_ALL_TYPE.SKIN_COLOR)
    type_value = models.IntegerField(verbose_name="对应值")
    type_image = models.CharField(verbose_name=u"图片", max_length=256, default='')
    type_image_desc = models.CharField(verbose_name=u"图片描述", max_length=256, default='')
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')
    topic_id = models.IntegerField(verbose_name=u"话题id", default=0)


class BlackheadPore(models.Model):
    class Meta:
        verbose_name = u'旷视黑头毛孔分类相关信息'
        db_table = 'api_blackhead_pore_type'

    blackhead_level = models.IntegerField(verbose_name="黑头程度", choices=KS_BLACKHEAD_TYPE,
                                       default=KS_BLACKHEAD_TYPE.NONE)
    pore_level = models.IntegerField(verbose_name="毛孔程度", choices=KS_PORE_TYPE,
                                        default=KS_PORE_TYPE.NONE)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')
    topic_id = models.IntegerField(verbose_name=u"话题id", default=0)


class ScanSkinVideo(models.Model):

    class Meta:
        verbose_name = u'AI精选视频封面配置'
        db_table = 'api_scan_skin_video'

    title = models.CharField(max_length=64, verbose_name="视频标题", default='')
    header_title = models.CharField(max_length=100, verbose_name="头部主标题", default='')
    header_subtitle = models.CharField(max_length=100, verbose_name="头部副标题", default='')
    weight = models.IntegerField(verbose_name=u'权重')
    tractate_id = models.IntegerField(verbose_name=u'帖子ID')
    channel = models.IntegerField(verbose_name=u'渠道', default=AI_VIDEO_CHANNEL.TEST_SKIN)
    unlock_img_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=255, verbose_name=u'未解锁静态图')
    gif_img_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=255, verbose_name=u'GIF图')
    static_img_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=255, verbose_name=u'静态图')

    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)

    def detail(self):

        return {
            "title": self.title,
            "header_title": self.header_title,
            "header_subtitle": self.header_subtitle,
            "weight": self.weight,
            "tractate_id": self.tractate_id,
            "gif_img_url": self.gif_img_url,
            "static_img_url": self.static_img_url,
            "lock_img_url": self.unlock_img_url,
        }
