# coding=utf8
from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import (
    SLIDE_USER_TYPE,
    SLIDE_PAYMENT_TYPE,
    REQUEST_SOURCE
)
from .area import Region, City


class Hot(models.Model):
    class Meta:
        verbose_name = u'热门榜'
        db_table = 'api_hot'

    name = models.CharField(max_length=100, verbose_name=u'名称')
    pic = ImgUrlField(img_type=IMG_TYPE.SPECIAL, max_length=255, verbose_name=u'图片', default=u'', )
    sort_num = models.IntegerField(max_length=100, verbose_name=u'排序', default=100)
    region = models.ManyToManyField(Region, verbose_name=u'大区id列表', through=u'HotRegion')
    city = models.ManyToManyField(City, verbose_name=u'城市id列表', through=u'HotCity')
    user_type = models.CharField(max_length=2, verbose_name=u'新老用户/全部', choices=SLIDE_USER_TYPE, default=SLIDE_USER_TYPE.ALL_USER)
    pay_type = models.CharField(max_length=2, choices=SLIDE_PAYMENT_TYPE, default=SLIDE_PAYMENT_TYPE.ALL_PAYMENT)
    is_online = models.BooleanField(verbose_name=u'是否上线', default=True)
    topic = models.CharField(max_length=255, verbose_name=u'关联自定义专题')
    new_topic = models.CharField(max_length=255, verbose_name=u'关联自定义专题(新)')
    begin_time = models.DateTimeField(verbose_name=u'生效时间', blank=True, null=True)
    offline_time = models.DateTimeField(verbose_name=u'下线时间', blank=True, null=True)
    channel = models.CharField(verbose_name=u'展示渠道', max_length=32, choices=REQUEST_SOURCE.choices, default=REQUEST_SOURCE.GEMGMEI)
    create_at = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_at = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class HotRegion(models.Model):
    class Meta:
        verbose_name = u'热门榜大区'
        db_table = 'api_hot_region'

    hot = models.ForeignKey(Hot, verbose_name=u'热门榜')
    region = models.ForeignKey(Region, verbose_name=u'关联大区')


class HotCity(models.Model):
    class Meta:
        verbose_name = u'热门榜城市'
        db_table = 'api_hot_city'

    hot = models.ForeignKey(Hot, verbose_name=u'热门榜')
    city = models.ForeignKey(City, verbose_name=u'关联城市')