#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__: vv
# Date: 2019/8/29

from django.conf import settings
from django.db import models
from gm_types.gaia import MARKET_TAG_TYPE, XIAOYING_GENDER, MARKEY_TAG_PAY_TYPE


class MarketTag(models.Model):
    class Meta:
        verbose_name = u'营销标签'
        db_table = 'api_market_tag'
        app_label = 'api'

    search_condition = models.TextField(verbose_name=u'搜索条件')
    nums = models.IntegerField(verbose_name=u'人群数量', default=0)
    operater = models.CharField(verbose_name=u'操作人', max_length=128)
    reason = models.CharField(verbose_name=u'操作理由', max_length=128)
    tag_name = models.CharField(verbose_name=u'标签名称', max_length=128, db_index=True)
    description = models.CharField(verbose_name=u'标签描述', max_length=128)
    is_online = models.BooleanField(verbose_name=u'是否在线', default=True)
    updated_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
    tag_type = models.IntegerField(verbose_name=u'标签类型', default=MARKET_TAG_TYPE.SHEQU, choices=MARKET_TAG_TYPE)


class MarketPersonas(models.Model):
    class Meta:
        verbose_name = u'用户画像'
        db_table = 'api_market_personas'
        app_label = 'api'
        unique_together = ("device_id", "tag_id")

    objects = models.Manager().db_manager(using=settings.DB_JERRY_TIDB)

    tag_id = models.IntegerField(verbose_name=u'标签ID')
    score = models.FloatField(verbose_name=u'得分', default=0, db_index=True)
    weight = models.FloatField(verbose_name=u'占比', default=0, db_index=True)
    device_id = models.CharField(verbose_name=u'设备id', max_length=128)
    pay_type = models.IntegerField(verbose_name=u'支付状态', choices=MARKEY_TAG_PAY_TYPE, db_index=True)


class MarketActivityUserProfile(models.Model):
    class Meta:
        verbose_name = u'用户活跃'
        db_table = 'api_market_activity_user_profile'
        app_label = 'api'

    age = models.IntegerField(verbose_name=u'年龄', db_index=True)
    city_id = models.CharField(verbose_name=u'城市id', max_length=128, db_index=True)
    device_id = models.CharField(verbose_name=u'设备id', max_length=128, db_index=True)
    active_time = models.CharField(verbose_name=u'活跃时间', max_length=32, db_index=True)
    register_time = models.CharField(verbose_name=u'注册时间', max_length=32, db_index=True)
    sex = models.CharField(max_length=2, verbose_name=u'性别', choices=XIAOYING_GENDER)
    user_id = models.CharField(verbose_name=u'用户ID', max_length=32, unique=True)
