#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__: vv
# Date: 2019/8/30

from django.db import models
from gm_types.gaia import USERCALL_STATUS, USERCALL_EVENT_TYPE, USERACTIVE_STATUS
from gm_upload import ImgUrlField, IMG_TYPE


class ProtectPhone(models.Model):
    class Meta:
        verbose_name = u'用户手机号隐私保护'
        db_table = 'api_protectphone'
        app_label = 'api'

    favor = models.CharField('喜好', max_length=128)
    city_id = models.CharField('城市', max_length=64)
    operator = models.CharField("呼叫人员", max_length=32, db_index=True)
    user_id = models.CharField('用户id', db_index=True, max_length=64)
    wechat = models.CharField('微信号', max_length=64, null=True)
    is_get_wechat = models.BooleanField('是否获取微信', default=False)
    bind_time = models.DateTimeField("绑定时间", null=True)
    unbind_time = models.DateTimeField("解绑时间", null=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True, null=True)
    update_time = models.DateTimeField('更新时间', auto_now=True, null=True)
    subscriptionid = models.CharField('绑定id', null=True, max_length=128)
    call_status = models.IntegerField('呼叫状态', default=USERCALL_STATUS.NOT_HANDLE, choices=USERCALL_STATUS)
    event_id = models.CharField('事件ID', max_length=64, null=True, db_index=True)
    event_type = models.IntegerField('事件类型', default=USERCALL_EVENT_TYPE.ORDER_CHECK, choices=USERCALL_EVENT_TYPE, null=True, db_index=True)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)


class ProtectPhoneLog(models.Model):
    class Meta:
        verbose_name = u'绑定记录表(AXB)'
        db_table = "api_protectphonelog"
        app_label = "api"
    a_user_id = models.CharField(u'A用户ID', max_length=128)
    b_user_id = models.CharField(u'B用户ID', max_length=128)
    x_phone_num = models.CharField(u'绑定中间号', max_length=128)
    subscriptionid = models.CharField('绑定id', null=True, max_length=128)
    is_delete = models.BooleanField('是否删除', default=False)
    create_time = models.DateTimeField("创建时间", auto_now_add=True, null=True)
    update_time = models.DateTimeField('更新时间', auto_now=True, null=True)
    event_type = models.IntegerField('事件类型', default=USERCALL_EVENT_TYPE.ORDER_CHECK, choices=USERCALL_EVENT_TYPE, null=True)
    protect_phone_id = models.IntegerField('隐私保护id', default=0)


# 说明:
# 该文件中对应的是hera项目中华为云私密账号通话的数据记录
# 上面的ProtectPhoneLog表和ProtectPhone是之前创建的, 供hera项目中三个页面使用:
#   1. 用户回拨列表 : http://hera.paas.env/big/list/bdtransfer/call_back_list_v1.html(测试环境链接)
#   2. 通话记录及录音 : http://hera.paas.env/big/list/doctor/show_voice_v1.html
#   3. 订单稽查列表: http://hera.paas.env/order/wait/adult_settled_v2/
#   4. 用户详情: http://hera.paas.env/user/detail/188/
# 这个四个功能列表之前被开发后,线上没有被使用（【用户详情中】的'绑定/解绑'按钮）, 且其中存在bug
# 现需要重新完善【用户回拨列表】功能, 但是不能影响【通话记录及录音】和【订单稽查列表】功能
# **重点:
# 所以现在创建了三个新表供【用户回拨列表】功能使用  **如果后者需要完善【通话记录及录音】【订单稽查列表】功能时, 可借鉴上面的表,需使用下面的表中的数据**


class HeraProtectPhoneUserCallbackList(models.Model):
    class Meta:
        verbose_name = u'hera项目下,商务转诊目录下,用户回拨列表'
        db_table = 'hera_protect_phone_user_callback_list'
        app_label = 'hera'

    user_id = models.CharField('用户id', db_index=True, max_length=64)
    favor = models.CharField('喜好', max_length=128)
    city_id = models.CharField('城市', max_length=64)
    is_get_wechat = models.BooleanField('是否获取微信', default=False)
    wechat = models.CharField('微信号', max_length=64, null=True)
    operator_id = models.CharField("呼叫人员id", max_length=64, db_index=True)

    subscription_id = models.CharField('该用户最后一次绑定id', null=True, max_length=255)
    bind_time = models.DateTimeField("该用户最后一次绑定时间", null=True)
    unbind_time = models.DateTimeField("该用户最后一次解绑时间", null=True)

    session_id = models.CharField('该用户最后一次通话链路id', null=True, max_length=255)
    call_status = models.IntegerField('该用户最后一次呼叫状态', null=True, choices=USERCALL_STATUS)


class HeraProtectPhoneHuaweiyunBindingRelationship(models.Model):
    class Meta:
        verbose_name = u'华为云私密账号通话绑定关系表'
        db_table = 'hera_protect_phone_huaweiyun_binding_relationship'
        app_label = 'hera'

    subscription_id = models.CharField('绑定id', null=True, max_length=255)
    operator_id = models.CharField("呼叫人员id", max_length=64, db_index=True)
    user_id = models.CharField('用户id', db_index=True, max_length=64)
    relationNum = models.CharField('X中间号码', max_length=64)
    bind_time = models.DateTimeField("绑定时间", null=True)
    unbind_time = models.DateTimeField("解绑时间", null=True)
    is_bind = models.BooleanField('是否在绑定状态', default=True)


class HeraProtectPhoneHuaweiyunCallRecords(models.Model):
    class Meta:
        verbose_name = u'华为云私密账号通话记录表'
        db_table = 'hera_protect_phone_huaweiyun_call_records'
        app_label = 'hera'

    session_id = models.CharField('通话链路id', null=True, max_length=255)
    subscription_id = models.CharField('绑定id', null=True, max_length=255)
    operator_id = models.CharField("呼叫人员id", max_length=64, db_index=True)
    user_id = models.CharField('用户id', db_index=True, max_length=64)
    call_status = models.IntegerField('呼叫状态', default=USERCALL_STATUS.NOT_HANDLE, choices=USERCALL_STATUS)
    active_status = models.IntegerField('有效状态', choices=USERACTIVE_STATUS, null=True)
    active_status_time = models.DateTimeField('有效状态为[挂断/拒绝/被骚扰]时的限制通话时间', null=True)
    call_in_time = models.DateTimeField('呼入时间', null=True)
    call_end_time = models.DateTimeField('呼叫结束时间', null=True)
    duration = models.IntegerField('通话时长', null=True)
    remark = models.CharField('备注信息', max_length=1024)
    audio_url = ImgUrlField(img_type=IMG_TYPE.AUDIO, max_length=255, verbose_name='音频地址', blank=True, default='')
