# coding:utf8
from django.db import models
from django.db.models import Q

from api.tool.geo_tool import calc_distances_by_lat_lnt, display_distances
from .special import Special
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import TOP_RANK_TYPE, RANKBOARD_TYPE, HOSPITAL_TYPE, DOCTOR_TYPE, WORLD_AREA_TYPE
from gm_types.gaia import RANKBOARD_DATA_TYPE
from api.models import Region, City, Tag, Share
from api.models import Service, Hospital, Doctor


class TopRankBanner(models.Model):
    class Meta:
        verbose_name = u'榜单头图'
        app_label = u'api'

    city_id = models.CharField(verbose_name=u'城市ID', max_length=128)
    city_name = models.CharField(verbose_name=u'城市ID', max_length=128)
    rank_type = models.CharField(verbose_name=u'榜单类型', max_length=8, choices=TOP_RANK_TYPE)
    img_src = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=300, verbose_name=u'榜单头图', blank=True, null=True)
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
    create_at = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)


class TopRankMeddle(models.Model):
    class Meta:
        verbose_name = u'榜单干预'
        app_label = u'api'


    city_id = models.CharField(verbose_name=u'城市ID', max_length=128)
    city_name = models.CharField(verbose_name=u'城市ID', max_length=128)
    rank_type = models.CharField(verbose_name=u'榜单类型', max_length=8, choices=TOP_RANK_TYPE)
    sort_idx = models.IntegerField(verbose_name=u'排名名次', max_length=30)
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
    create_at = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    start_time = models.DateTimeField(verbose_name=u'开始时间')
    end_time = models.DateTimeField(verbose_name=u'结束时间')
    target_id = models.CharField(verbose_name=u'关联的ID(医生或机构)', max_length=128)
    target_name = models.CharField(verbose_name=u'关联的名称(医生或机构)', max_length=200)



