# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function
import datetime

# Enumeration is deprecated, reference: http://git.gengmei.cc/backend/gm-types
from rpc.tool.enumeration import Enumeration
from gm_types.gaia import *

image_url_header = u'http://pic.igengmei.com/'

SUBSCRIBE_PLATFORM_IPHONE = 'iPhone'

ORDER_STATUS_DETAILS = {
    '0': u'您的订单还未付款，请在48小时内完成支付。',
    '1': u'收到所长的短信了吗？赶快去医院就诊吧！',
    '2': u'恭喜您顺利体验我们的福利，发体验帖可以赢取更多美分哦！',
    '3': u'系统已受理，请您耐心等待。',
    '4': u'系统已退款到您的账户，请查收。',
    '5': u'您已成功发表体验帖，快去看看大家的回复吧！',
    '6': u'您已取消本次订单，欢迎查看其他福利。'
}

payment_type_to_payment_type_v2_map = {
    PAYMENT_TYPE.FULL_PAYMENT: PAYMENT_TYPE_V2.STANDARD,
    PAYMENT_TYPE.PREPAYMENT: PAYMENT_TYPE_V2.STANDARD,
    PAYMENT_TYPE.FREE_PAYMENT: PAYMENT_TYPE_V2.FREE_PAYMENT,
    PAYMENT_TYPE.EXCHANGE_GIFT: PAYMENT_TYPE_V2.ENTITY,
}


def payment_type_to_payment_type_v2(pt):
    return payment_type_to_payment_type_v2_map[pt]


DEFAULT_LAST_VIEW_DATETIME = datetime.datetime(2012, 10, 22)

POINTS_REASON_RULE = {
    POINTS_TYPE.INVITE: 200,
    POINTS_TYPE.WAS_INVITE: 100,
    POINTS_TYPE.APP: 50,
    POINTS_TYPE.VOTE: 10,
    POINTS_TYPE.SHARE: 100,
    POINTS_TYPE.STAR: 500,
    POINTS_TYPE.CANCEL_ORDER: 0,
    POINTS_TYPE.BUY_SERVICE: 0,
    POINTS_TYPE.REGISTER: 300,
    POINTS_TYPE.VOTE_OTHER: 5,
    POINTS_TYPE.REPLY_OTHER: 5,
    POINTS_TYPE.LOGIN: 20,
    POINTS_TYPE.REPLIED: 10,
    POINTS_TYPE.HOT: 1500
}
