# coding:utf-8
"""名医大赏相关配置"""
import datetime

# 往年版名医大赏报名项目
famous_doctors_items = [
    {"id": 1, "order": 1, "name": "人气"},
    {"id": 2, "order": 2, "name": "口碑"},
    {"id": 3, "order": 3, "name": "实力"},
    {"id": 4, "order": 4, "name": "鼻部"},
    {"id": 5, "order": 5, "name": "眼部"},
    {"id": 6, "order": 6, "name": "颌面"},
    {"id": 7, "order": 7, "name": "皮肤"},
    {"id": 8, "order": 8, "name": "抗衰"},
    {"id": 9, "order": 9, "name": "胸部"},
    {"id": 10, "order": 10, "name": "脂肪"},
    {"id": 11, "order": 11, "name": "私密"},
    {"id": 12, "order": 12, "name": "毛发"},
]

# 获奖医生、医院名单
# prize_doctors = [
#     {"item_id": 1, "doctor_ids": ["9b0b1b2af41411e6903d0242c0a8020b"], "prize_name": "2019-年度人气整形医生"},
#     {"item_id": 2, "doctor_ids": ["7159e636b5f711e6903d0242c0a8020b"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 3, "doctor_ids": ["0a6d3de0d89511e6903d0242c0a8020b"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 4, "doctor_ids": ["fb084922d24411e6903d0242c0a8020b", "75c4ec00d22d11e6903d0242c0a8020b"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 5, "doctor_ids": ["f7de082172b240e4adc3d1f92e484c33"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 6, "doctor_ids": ["01e397d9fb1f4bc3805a40dddaa77a6d"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 7, "doctor_ids": ["72d685b4759a4dd2a60dc237d002ecb0"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 8, "doctor_ids": ["3433497941fb4a589381b9eb8bc261d9"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 9, "doctor_ids": ["b3f371906891420fa0307616e4bb1fce"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 10, "doctor_ids": ["7ed90e9f339043168647c52fe7a1870a"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 11, "doctor_ids": ["f7ebc4a724094549a2d8d6b57ee4d02e"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 12, "doctor_ids": ["d099b8e49d6447f180d3a8b3078ce3bd"], "prize_name": "金牌眼部整形医生奖"},
# ]

prize_doctors = [
    {"item_id": 1, "doctor_ids": ["1000195", "4a41e57457504ca28a29190bb4cf6d2d",
                                  "ba5987d3940d432eaf7963725fc08ea0"], "prize_name": "2019-年度人气整形医生"},
    {"item_id": 2, "doctor_ids": ["6ca9d1f0c87d4d0288aa854f6c9b2cbe"], "prize_name": "2019-年度口碑整形医生"},
    {"item_id": 3, "doctor_ids": ["xurongyang"], "prize_name": "2019-年度实力整形医生"},
    {"item_id": 4, "doctor_ids": ["7c9e39ec203a48fd8c8b48bdbaa38e24"], "prize_name": "2019-年度优秀鼻部整形医生"},
    {"item_id": 5, "doctor_ids": ["02d70c57ffd042cb9eff23016514db2d"], "prize_name": "2019-年度优秀眼部整形医生"},
    {"item_id": 6, "doctor_ids": ["6ca9d1f0c87d4d0288aa854f6c9b2cbe"], "prize_name": "2019-年度优秀颌面整形医生"},
    {"item_id": 7, "doctor_ids": ["75338901104f48b5a726004523c2817b"], "prize_name": "2019-年度优秀皮肤管理医生"},
    {"item_id": 8, "doctor_ids": ["205f4562ad5c4d5f934e3ad41636572a"], "prize_name": "2019-年度优秀抗衰管理医生"},
    {"item_id": 9, "doctor_ids": ["2ff1b82408d544bd85ff500527b97c41"], "prize_name": "2019-年度优秀胸部整形医生"},
    {"item_id": 10, "doctor_ids": ["6786cb80650f11e6a42100163e001c72", "7413e93128be4da8a1111616d1649f0d"],
     "prize_name": "2019-年度优秀脂肪管理医生"},
    {"item_id": 11, "doctor_ids": ["9ad334757bd8472891c9d9226981dfd1"], "prize_name": "2019-年度优秀私密整形医生"},
    {"item_id": 12, "doctor_ids": ["f4018b64fd314a869abe180adbbd7eb4"], "prize_name": "2019-年度优秀毛发整形医生"},
]

# prize_hospitals = [
#     {"item_id": 1, "hospital_ids": ["bbsdsrmyysszxk", "bbsdyrmyyzxwk",], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 2, "hospital_ids": ["bbszyyy", "bbyxydefsyy", "bbyxydefsyyzxsswk",], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 3, "hospital_ids": ["bbyxyfsyyzxwk"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 4, "hospital_ids": ["bc58c1de4e2611e6a8c4f45c899f5365", "BCCKGJLS", "BCCKGJLSCD"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 5, "hospital_ids": ["BCCKGJLSHZ", "bcqzzzxzyy", "bcyjylmrmz"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 6, "hospital_ids": ["bdbtylmrzs", "bdcgm", "bdchpingan"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 7, "hospital_ids": ["bdckylmrzs", "bdczx"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 8, "hospital_ids": ["bdebhzkyy", "bdfyylmrzs"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 9, "hospital_ids": ["bdhmylmrzs", "bdldylmrzs"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 10, "hospital_ids": ["bdlshylmrzxzs", "bdlsylmrzs"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 11, "hospital_ids": ["bdmcxyy", "bdmwylmrzs", "bdpjylmrzs"], "prize_name": "金牌眼部整形医生奖"},
#     {"item_id": 12, "hospital_ids": ["bdrenmin", "bdsdeyyylmrk", "bdsdwyysszxmrk"], "prize_name": "金牌眼部整形医生奖"},
# ]

prize_hospitals = [
    {"item_id": 1, "hospital_ids": ["96ea37eef81d11e692f800163e000a4a", "a6e68171d66c4fb69275c82f76541c48",
                                    "839d8c47ff7c4c4cb82e617383926118"], "prize_name": "2019-年度人气整形机构"},
    {"item_id": 2,
     "hospital_ids": ["fb38be6e52b34b6d8efe7a30d2c93022", "whmjyylmrmzb3281", "b0b115d0804c458c9eb9b833fc94364b",
                      "schmzx", ], "prize_name": "2019-年度口碑整形机构"},
    {"item_id": 3, "hospital_ids": ["scjdyxyjfsyy"], "prize_name": "2019-年度实力整形机构"},
    {"item_id": 4, "hospital_ids": ["fb32833d473240fba50e4afa764a7d00"], "prize_name": "2019-年度优秀鼻部整形机构"},
    {"item_id": 5, "hospital_ids": ["shhhuamei"], "prize_name": "2019-年度优秀眼部整形机构"},
    {"item_id": 6, "hospital_ids": ["GZMEYXMR", "shrayy", "shmlcylmryy", "6c3ca49451474edf803101d13ed12896"],
     "prize_name": "2019-年度优秀颌面整形机构"},
    {"item_id": 7, "hospital_ids": ["shhhuamei"], "prize_name": "2019-年度优秀皮肤管理机构"},
    {"item_id": 8, "hospital_ids": ["szghmzb"], "prize_name": "2019-年度优秀抗衰管理机构"},
    {"item_id": 9, "hospital_ids": ["shyxylmryy2203"], "prize_name": "2019-年度优秀胸部整形机构"},
    {"item_id": 10, "hospital_ids": ["4d97a366e69311e5ae9100163e00062b"], "prize_name": "2019-年度优秀脂肪管理机构"},
    {"item_id": 11, "hospital_ids": ["c614856fe7c847c9b7f8a25f1aed40b8"], "prize_name": "2019-年度优秀私密整形机构"},
    {"item_id": 12, "hospital_ids": ["8981117cec0711e5977700163e000a4a"], "prize_name": "2019-年度优秀毛发整形机构"},
]


def list_items():
    famous_doctors_items.sort(key=lambda item: item["order"])

    return famous_doctors_items


def get_items_dict_info():
    res = {}
    for item in famous_doctors_conf_map.get('202010').get('items'):
        res[item["id"]] = item

    return res


# 名医大赏相关配置信息字典
# 新版名医大赏请更新下面配置文件
famous_doctors_conf_map = {
    "202010": {  # 版本key
        "version_title": "2020年第七届",  # 标题版本
        "title": "更美名医大赏",  # 标题
        "version": "202010",  # 版本
        "cents": 10000000,  # 活动结束的总美分
        "sign_start_time": "2020-11-03 00:00:00",  # 报名开始时间
        "sign_end_time": "2020-12-08 23:59:59",  # 报名结束时间
        "sign_rule": "限入驻更美APP的医生/机构；\
                      每个医生/机构最多报名3个奖项，一经报名不得修改",  # 报名规则
        "vote_start_time": "2020-11-03 00:00:00",  # 投票开始时间
        "vote_end_time": "2020-12-08 23:59:59",  # 投票结束时间
        "vote_rule": {  # 投票规则
            "des": "每人每天最多可投二十票，每个医生/机构的单个奖项最多可投5票；为保证公平，如发现恶意刷票将进行减票处理",  # 规则描述
            "vote_day_max": 20,  # 每天每人最多票数
            "vote_per_day_doctor_max": 5,  # 每天每人给每个医生的最多票数
        },
        "count_down": datetime.timedelta(days=1),  # 倒计时结束时间：1天
        "selection_time": "2020-11-03 00:00:00",  # 评选日期
        "selection_end_time": "2020-12-10 10:00:00",
        "award_time": "2020-12-10 10:00:00",  # 颁奖日期
        "award_end_time": "2020-12-17 23:59:59",  # 颁奖结束日期
        "award_des": "您投票的医生入围后，即有机会瓜分一千万美分",  # 领奖描述
        "selection_rule": "综合平台影响力、投票数、专家评审意见计算得分；平台影响力指截止到投票结束期，相关报名类目的案例数量和用户口碑的综合得分\
                          注：本次大赛最终解释权归更美APP所有",  # 评选规则
        "judges": [  # 评委
            "李勤：爱思特医疗美容集团首席专家，国务院政府特殊津贴专家，中国整形美容协会面部年轻化分会会长。擅长应用从非手术到手术的面部年轻化综合治疗。",
            "余力：中华医学会整形外科分会乳房整形学组副组长；中国整形美容协会乳房整形分会副会长；中国整形美容协会内窥镜整形外科分会副会长；国际美容整形外科学会（ISAPS）会员。",
            "韦敏：上海交通大学医学院附属第九人民医院整复外科颅颌面外科主任，从事整形外科、美容外科临床工作和研究25年，临床经验丰富，擅长高难度头面部骨骼整形及美容外科，鼻整形美容。"
        ],
        "share": {  # 分享相关配置
            1: {
                "page_name": "投票主页面1.1",  # 分享页
                "share_title": "更美人气名医&机构大比拼！",  # 分享标题
                "share_content": "听说名医都在这，快来支持你心中最棒的“TA”",  # 分享内容
                "params": []  # 需要参数
            },
            2: {
                "page_name": "报名页1.2",
                "share_title": "【第七届更美名医大赏】",
                "share_content": "寻找2020年度中国优秀医生 & 机构，速邀您的加入！",
                "params": ["doctor_type"]
            },
            3: {
                "page_name": "机构 / 医生详情页1.3、1.4",
                "share_title": "{name}入围【第七届更美名医大赏】评选，请您来投票！",
                "share_content": "2020年中国杰出整形机构 / 医生",
                "params": ["doctor_type"]
            },
            4: {
                "page_name": "机构 / 医生详情页1.3、1.4",
                "share_title": "叮！您的一千万美分已到账！",
                "share_content": "查看你支持的“TA”有没有脱颖而出",
                "params": ["doctor_type"]
            }
        },
        "items": [  # 报名项目
            {"id": 1, "order": 1, "name": "人气", "doc_type": 1},
            {"id": 2, "order": 2, "name": "口碑", "doc_type": 1},
            {"id": 3, "order": 3, "name": "实力", "doc_type": 1},
            {"id": 4, "order": 4, "name": "眼部", "doc_type": 0},
            {"id": 5, "order": 5, "name": "鼻部", "doc_type": 0},
            {"id": 6, "order": 6, "name": "胸部", "doc_type": 0},
            {"id": 7, "order": 7, "name": "颌面", "doc_type": 0},
            {"id": 8, "order": 8, "name": "脂肪", "doc_type": 0},
            {"id": 9, "order": 9, "name": "私密", "doc_type": 0},
        ],
        "reward": {  # 投票奖励
            1: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 100
                 }],
            2: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 100
                 }],
            3: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 100
                 }],
            4: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 100
                 }],
            5: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 100
                 }
                ],
            6: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 200
                 },
                {"reward_type": 2,
                 "des": "折券",
                 "prize": 3.9,
                 "channel_gift_id": '58938',
                 },
                ],
            7: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 200
                 }],
            8: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 200
                 }],
            9: [{"reward_type": 1,
                 "des": "美分",
                 "prize": 200
                 }],
            10: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 200
                  }
                 ],
            11: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 300
                  }],
            12: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 300
                  }],
            13: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 300
                  }],
            14: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 300
                  }],
            15: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 300
                  }
                 ],
            16: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 400
                  },
                 {
                     "reward_type": 2,
                     "des": "折券",
                     "prize": 3.6,
                     "channel_gift_id": "58939"
                 }
                 ],
            17: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 400
                  }],
            18: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 400
                  }],
            19: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 400
                  }],
            20: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 400
                  }],
            21: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 500
                  }],
            22: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 500
                  }],
            23: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 500
                  }],
            24: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 500
                  }],
            25: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 500
                  }],
            26: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  },
                 {
                     "reward_type": 2,
                     "des": "折券",
                     "prize": 3.3,
                     "channel_gift_id": "58940",
                 }],
            27: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  }],
            28: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  }],
            29: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  }],
            30: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  }],

            31: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 600
                  }],

            32: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 700
                  }],

            33: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 800
                  }],

            34: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 900
                  }],

            35: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 1000
                  }],

            36: [{"reward_type": 1,
                  "des": "美分",
                  "prize": 1000
                  },
                 {
                     "reward_type": 2,
                     "des": "折券",
                     "prize": 3.0,
                     "channel_gift_id": "58941"
                 },
                 {
                     "reward_type": 3,
                     "des": "无门槛",
                     "prize": 50,
                     "channel_gift_id": "58941"
                 }
                 ]
        },
        "reward_day_list": [6, 16, 26, 36],  # 券奖励时间节点（天）

        # 相关获奖信息（写死的）
        "prize_doctors": [
            {"item_id": 4, "doctor_ids": ["3311cd2687ca43e4ac3511a9a4b3f1241"], "prize_name": "2020-年度优秀鼻部整形医生"},
            {"item_id": 5, "doctor_ids": ["2ad988bae0134628aa9326e8cc886a8e"], "prize_name": "2020-年度优秀眼部整形医生"},
            {"item_id": 6, "doctor_ids": ["6ca9d1f0c87d4d0288aa854f6c9b2cbe"], "prize_name": "2020-年度优秀颌面整形医生"},
            {"item_id": 7, "doctor_ids": ["75338901104f48b5a726004523c2817b"], "prize_name": "2020-年度优秀皮肤管理医生"},
            {"item_id": 8, "doctor_ids": ["205f4562ad5c4d5f934e3ad41636572a"], "prize_name": "2020-年度优秀抗衰管理医生"},
            {"item_id": 9, "doctor_ids": ["2ff1b82408d544bd85ff500527b97c41"], "prize_name": "2020-年度优秀胸部整形医生"},
        ],
        "prize_hospitals": [
            {"item_id": 1, "hospital_ids": ["100019", "bbsdyrmyyzxwk", ], "prize_name": "金牌眼部整形医生奖"},
            {"item_id": 2, "hospital_ids": ["bbszyyy", "bbyxydefsyy", "bbyxydefsyyzxsswk", ],
             "prize_name": "金牌眼部整形医生奖"},
            {"item_id": 3, "hospital_ids": ["bbyxyfsyyzxwk"], "prize_name": "金牌眼部整形医生奖"},
        ]
    }
}


def prize_des(version, now_day_count):
    """
    根据天数查询领取美分和优惠券
    """
    conf = famous_doctors_conf_map.get(version, {})
    reward = conf.get("reward")
    reward_day_list = conf.get("reward_day_list")
    now_reward = reward.get(now_day_count + 1, [])
    des = ""  # 信息描述
    prize_str = ""  # 奖励信息
    extra_prize_str = ""  # 额外奖励描述
    if now_reward:
        for r in now_reward:  # 今天领的奖励
            prize_str += " + " + str(r.get("prize")) + (r.get("des"))
        for d in reward_day_list:  # 遍历领奖时间节点找寻关键时间点的奖励
            if now_day_count + 1 < d:
                for r in reward.get(d):
                    if r.get("reward_type") == 1:
                        continue
                    extra_prize_str += " + " + str(r.get("prize")) + (r.get("des"))
                des = "投票成功,送您" + prize_str[3:] + ",\n再坚持投票" + str(d - now_day_count - 1) + "天还可得" + extra_prize_str[3:]
                break
            else:
                continue
        else:
            des += "送您" + prize_str[3:] + "，\n所有奖励已领完！"
    else:
        des = "投票成功"
    return des, now_reward


