# -*- coding: utf-8 -*-

import json
from gm_types.gaia import SCAN_TYPE
from rpc.cache import ai_pop_windows_cache


class PopWindow(object):

    def __init__(self, device_id, redis=ai_pop_windows_cache, pop_type=SCAN_TYPE.SCAN_SKIN):
        self.device_id = device_id
        self.read_key = "ai_pop_windows_{}_{}_read".format(device_id, pop_type)
        self.pop_key = "ai_pop_windows_{}_{}".format(device_id, pop_type)
        self.redis = redis
        self.POPS = {
            "skin_color": {
                "id": "skin_color",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/6c7f5bd0ee-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6341),
                "title": "预算百元，医美怎样让你白到极致？",
            },
            "smooth": {
                "id": "smooth",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/f7fb9a1d1c-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6342),
                "title": "30天让你的肌肤嫩滑如婴儿肌",
            },
            "dark_circle": {
                "id": "dark_circle",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/045aa6afab-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=5930),
                "title": "听说千元以下就可以解决顽固黑眼圈？",
            },
            "acne": {
                "id": "acne",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/dacb24309e-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=5932),
                "title": "抗痘到底怎么做，看这篇就够了",
            },
            "black_head": {
                "id": "black_head",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/cd8ef8ec3e-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=5933),
                "title": "毛孔细致得让闺蜜服输的100个理由",
            },
            "skin_oil": {
                "id": "skin_oil",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/9f2305147c-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6343),
                "title": "平价医美也能有10000底妆效果！",
            },
            "wrinkles": {
                "id": "wrinkles",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/ceeef60435-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6134),
                "title": "让你真的童颜回春的2种方法",
            },
            "eye_bags": {
                "id": "eye_bags",
                "image_url": "https://pic.igengmei.com/topicimage/2019/12/26/134d101e4c-s",
                "gm_url": "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6133),
                "title": "眼袋秘籍，让你一个星期重回青春巅峰！",
            },
            #扫脸弹窗多对一现象  以专题id作为弹窗id

            6712: {
                'id': '6712',
                'image_url': 'https://heras.igengmei.com/2020/02/07/5219f6b681',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6712),
                'title': '那些美到让人难忘的眼睛到底赢在哪里？'
            },
            6713: {
                'id': '6713',
                'image_url': 'https://heras.igengmei.com/2020/02/07/0e90a1bcd9',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6713),
                'title': '女星直言打过针，这入门项目还不get？'
            },
            6717: {
                'id': '6717',
                'image_url': 'https://heras.igengmei.com/2020/02/07/21e3def34b',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6717),
                'title': '眼距过宽和眼距过窄如何自救逆袭？'
            },
            6715: {
                'id': '6715',
                'image_url': 'https://heras.igengmei.com/2020/02/07/5841da9490',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6715),
                'title': '宽鼻翼，让你无法变美的罪魁祸首'
            },
            6721: {
                'id': '6721',
                'image_url': 'https://heras.igengmei.com/2020/02/07/ffd07ee554',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6721),
                'title': '一份姐妹群统计：整微笑唇增加桃花运600%！'
            },
            6718: {
                'id': '6718',
                'image_url': 'https://heras.igengmei.com/2020/02/07/080218eaae',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6718),
                'title': '99%的美人不会有的特质是？人中长！'
            },
            6716: {
                'id': '6716',
                'image_url': 'https://heras.igengmei.com/2020/02/07/5304bfaed0',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6716),
                'title': '请查收：锦鲤村花的一份私整秘籍。'
            },
            6719: {
                'id': '6719',
                'image_url': 'https://heras.igengmei.com/2020/02/07/03760db106',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6719),
                'title': '揭秘韩国富贵手术除了鼻基底还要整这里！'
            },
            6720: {
                'id': '6720',
                'image_url': 'https://heras.igengmei.com/2020/02/07/3dd4b317ad',
                'gm_url': "gengmei://welfare_special?service_id={id}&is_new_special=0&source_from=ai".format(id=6720),
                'title': '一位女孩心酸自述；我不想她们说我克夫了！'
            }
        }

        self.FACE_SYMPTOM_CONF = {
            '单眼皮': 6712,
            '内双': 6712,
            '方脸': 6713,
            '钻石脸': 6713,
            '梨形脸': 6713,
            '下颌突出': 6713,
            '娃娃脸': 6713,
            '鹅蛋脸': 6713,
            '适中': 6713,
            '瓜子脸': 6713,
            '长型脸': 6713,
            '流畅': 6713,
            '眼距过宽': 6717,
            '眼距略宽': 6717,
            '眼距适中': 6717,
            '宽鼻翼': 6715,
            '标准鼻翼': 6715,
            '薄唇': 6721,
            '态度唇': 6721,
            '微笑唇': 6721,
            '嘴唇位置偏下': 6718,
            '嘴唇位置适中': 6718,
            '嘴唇位置偏上': 6718,
            '颏部占比十分低-急需垫下巴': 6716,
            '颏部占比较低-需要垫下巴': 6716,
            '颏部占比略微低-可垫可不垫': 6716,
            '颏部占比略高-可垫可不垫': 6716,
            '颏部占比适中-不用垫下巴': 6716,
            '十分凹陷': 6719,
            '一般饱满': 6719,
            '饱满': 6719,
            '十分突出': 6719,
            '颧骨突出': 6720,
            '颧骨一般突出': 6720
        }

        self.pop_type = pop_type
        self.defaut_pops = ["wrinkles", "eye_bags", "skin_oil", "black_head", "dark_circle", "acne", "skin_color",
                            "smooth"] if pop_type == SCAN_TYPE.SCAN_SKIN else [u"方脸"]

    def cache_pop_windows(self, pop_windows):
        if self.pop_type == SCAN_TYPE.SCAN_FACE:
            pop_windows = self.get_pop_ids(pop_windows)
        self.redis.setex(self.pop_key, 86400 * 60, json.dumps(pop_windows))
        return pop_windows

    def cache_pop_windows_read(self, pop_window_id):
        self.redis.sadd(self.read_key, pop_window_id)
        self.redis.expire(self.read_key, 86400 * 60)

    def get_pop_windows(self):
        all_pops = json.loads(self.redis.get(self.pop_key) or "[]")
        read_pops = self.redis.smembers(self.read_key)
        if not all_pops:
            self.redis.delete(self.read_key)
            all_pops = self.defaut_pops
            all_pops = self.cache_pop_windows(all_pops)

        res_pop_id = None
        for item in all_pops:
            if str.encode(str(item)) not in read_pops:
                res_pop_id = item
                break

        if not res_pop_id:
            res_pop_id = all_pops[0]
            self.redis.delete(self.read_key)

        self.cache_pop_windows_read(res_pop_id)

        pop_window = self.POPS.get(res_pop_id, {})
        if pop_window:
            pop_window["content"] = "等待报告的过程中先看一下你的定制方案吧！"

        return self.POPS.get(res_pop_id, {})

    def get_pop_ids(self, symptoms):
        #不能改变原来顺序
        res = []
        for symptom in symptoms:
            symptom_id = self.FACE_SYMPTOM_CONF.get(symptom.encode('utf-8'))
            if symptom_id and symptom_id not in res:
                res.append(symptom_id)
        return res




