#! /usr/bin/env python
# -*- coding: utf-8 -*-
from celery import shared_task
from django.conf import settings
from gm_types.gaia import MESSAGE_TYPE

from rpc.context import get_rpc_remote_invoker

rpc_invoker = get_rpc_remote_invoker()


@shared_task
def send_msg_for_new_user(target_user_id):
    """
    完美所长给新用户发送欢迎私信
    :return:
    """
    content = {"text": "新人特权仅剩22小时!!! 光子嫩肤/水光针/瘦脸针全场￥0，10min无创速美，机会仅此一次，过期失效啦",
               "url": settings.SUOZHANG_WEL_URL}
    rpc_invoker['message/suozhang/send'](target_user_id=target_user_id, content=content,
                                         msg_type=MESSAGE_TYPE.TEXT_WITH_URL).unwrap()
