# -*- coding: utf-8 -*-
""" 每天定时同步 马甲用户到缓存池. """
from django.conf import settings

from api.models import Person
from celery import shared_task
from rpc.cache import puppet_users_cache
from rpc.tool.log_tool import info_logger


@shared_task
def sync_puppet_user_to_cache():
    """ 同步马甲用户到缓存池 (直播业务) .
    预计 30 万
    """

    key = "puppet_user_ids_set"

    user_ids = Person.objects.using(settings.SLAVE_DB_NAME).filter(is_puppet=True).values_list('user_id', flat=True)

    total_count = len(user_ids)
    chunk_size = 10000  # 1万
    offset = 0

    while offset < total_count:
        chunked_user_ids = user_ids[offset:offset+chunk_size]
        puppet_users_cache.sadd(key, *chunked_user_ids)
        offset += chunk_size

    info_logger.info("sync_puppet_user_to_cache done ! total count: {}".format(total_count))