# coding:utf-8

from rpc.decorators import bind
from rpc.cache import user_directional_push_cache


@bind('api/user/directional_push')
def user_directional_push(user_id, open_directional_push):

    if not open_directional_push:
        user_directional_push_cache.hset('user_directional_push_cache', str(user_id), 1)
    else:
        user_directional_push_cache.hdel('user_directional_push_cache', str(user_id))

    return


@bind('api/user/directional_push/status')
def user_directional_push_status(user_id):

    status = user_directional_push_cache.hget('user_directional_push_cache', str(user_id))
    if status:
        return False

    return True


@bind('api/user/directional_push/all_user_ids')
def get_directional_push_status_by_user_ids():
    """获取所有关闭了个性化推送的用户id"""
    user_ids = user_directional_push_cache.hkeys('user_directional_push_cache')
    return user_ids