# -*- coding:utf-8 -*-
'''
对外提供用户接口服务
'''

from django.contrib.auth.models import User
from rpc.decorators import bind
from api.util.user_util import simple_user_info_by_user_ids, simple_doctor_info_by_user_ids


@bind('api/user/simple_user_info')
def get_simple_user_info(user_ids):
    '''
    批量获取简单用户数据
    user_ids: 用户id列表
    return:
        {   int:  dict
            uid1: {},
            uid2: {}
        }
    '''
    s_user_info = simple_user_info_by_user_ids(user_ids)
    s_doc_info = simple_doctor_info_by_user_ids(user_ids)
    for k, v in s_user_info.items():
        dv = s_doc_info.get(k)
        if dv:
            v['doc_info'] = dv
    return s_user_info


@bind('api/user/get_phone_by_user_ids')
def get_phone_by_user_ids(user_ids):
    '''
    批量获取用户手机号码
    user_ids: 用户id列表
    return:
        {   int:  dict
            uid1: {},
            uid2: {}
        }
    '''
    result = list()
    res_users = User.objects.filter(id__in=user_ids).select_related('userextra').all()
    for u in res_users:
        u_info = dict()
        u_info['phone'] = u.userextra.phone
        u_info['user_id'] = u.id
        result.append(u_info)
    return result


@bind('api/user/get_date_joined_by_user_id')
def get_date_joined_by_user_id(user_id):
    """
     获取用户创建日期
    :param user_id:
    :return:
    """
    user_obj = User.objects.filter(id=user_id).first()
    return str(user_obj.date_joined) if user_obj else None

